/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.composites.SelectModelElementCompositeImpl;
import org.eclipse.emf.ecp.ui.common.CheckedEStructuralFeatureComposite;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckedEStructuralFeatureCompositeImpl
extends SelectModelElementCompositeImpl
implements CheckedEStructuralFeatureComposite {
    private final Object[] input;
    private FilteredViewerContentProvider provider;
    private final Map<Object, Boolean> objectToCheckedMap;

    public CheckedEStructuralFeatureCompositeImpl(Object input) {
        super(input);
        this.input = (Object[])input;
        this.objectToCheckedMap = new LinkedHashMap<Object, Boolean>();
    }

    @Override
    public Composite createUI(Composite parent) {
        Composite composite = super.createUI(parent);
        Composite buttons = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttons);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)buttons);
        Button buttonAll = new Button(buttons, 8);
        buttonAll.setText(Messages.CheckedModelElementHelper_SelectAllLabel);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)buttonAll);
        buttonAll.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 13806279721956126L;

            public void widgetSelected(SelectionEvent e) {
                CheckedEStructuralFeatureCompositeImpl.this.getViewer().setCheckedElements(CheckedEStructuralFeatureCompositeImpl.this.input);
                CheckedEStructuralFeatureCompositeImpl.this.provider.setCheckStateForAll(true);
            }
        });
        Button buttonNone = new Button(buttons, 8);
        buttonNone.setText(Messages.CheckedModelElementHelper_DeselectAllLabel);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)buttonNone);
        buttonNone.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 709950696987260126L;

            public void widgetSelected(SelectionEvent e) {
                CheckedEStructuralFeatureCompositeImpl.this.getViewer().setCheckedElements(new Object[0]);
                CheckedEStructuralFeatureCompositeImpl.this.provider.setCheckStateForAll(false);
            }
        });
        return composite;
    }

    @Override
    protected CheckboxTableViewer createViewer(Composite composite) {
        CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67586);
        tableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.provider = new FilteredViewerContentProvider(tableViewer);
        tableViewer.setContentProvider((IContentProvider)this.provider);
        tableViewer.setCheckStateProvider((ICheckStateProvider)this.provider);
        tableViewer.setInput(this.getInput());
        return tableViewer;
    }

    @Override
    public CheckboxTableViewer getViewer() {
        return (CheckboxTableViewer)super.getViewer();
    }

    @Override
    public Object[] getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.input.length) {
            Object cur = this.input[i];
            if (this.objectToCheckedMap.containsKey(cur) && this.objectToCheckedMap.get(cur).booleanValue()) {
                result.add(cur);
            }
            ++i;
        }
        return result.toArray();
    }

    private class FilteredViewerContentProvider
    implements IStructuredContentProvider,
    ICheckStateProvider {
        public FilteredViewerContentProvider(CheckboxTableViewer viewer) {
            viewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.put(event.getElement(), event.getChecked());
                }
            });
        }

        public boolean isChecked(Object element) {
            return this.getCheckedState(element);
        }

        private boolean getCheckedState(Object element) {
            if (!CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.containsKey(element)) {
                CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.put(element, Boolean.FALSE);
            }
            return (Boolean)CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.get(element);
        }

        public boolean isGrayed(Object element) {
            return false;
        }

        public void setCheckStateForAll(boolean state) {
            Set keySet = CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.keySet();
            for (Object o : keySet) {
                CheckedEStructuralFeatureCompositeImpl.this.objectToCheckedMap.put(o, state);
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

