/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EObjectObservableMap;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ECPFocusCellDrawHighlighter;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableViewerColumnBuilder;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableColumnConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableControlConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.CellReadOnlyTesterHelper;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.core.swt.AbstractControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.swt.Activator;
import org.eclipse.emf.ecp.view.spi.table.swt.DetailDialog;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableControlSWTRenderer
extends AbstractControlSWTRenderer<VTableControl> {
    private SWTGridDescription rendererGridDescription;
    private static final String FIXED_COLUMNS = "org.eclipse.rap.rwt.fixedColumns";
    private static final String ICON_ADD = "icons/add.png";
    private static final String ICON_DELETE = "icons/delete.png";
    private TableViewer tableViewer;
    private Label validationIcon;
    private Button addButton;
    private Button removeButton;
    private Button detailEditButton;

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Iterator settings = ((VTableControl)this.getVElement()).getDomainModelReference().getIterator();
        if (!settings.hasNext()) {
            return null;
        }
        final EStructuralFeature.Setting mainSetting = (EStructuralFeature.Setting)settings.next();
        final EClass clazz = ((EReference)mainSetting.getEStructuralFeature()).getEReferenceType();
        TableControlConfiguration tableControlConfiguration = new TableControlConfiguration();
        tableControlConfiguration.setAddRemoveDisabled(((VTableControl)this.getVElement()).isAddRemoveDisabled());
        for (VDomainModelReference column : this.getTableDomainModelReference().getColumnDomainModelReferences()) {
            boolean readOnly = TableConfigurationHelper.isReadOnly((VTableControl)this.getVElement(), column);
            tableControlConfiguration.getColumns().add(new TableColumnConfiguration(readOnly, (EAttribute)column.getEStructuralFeatureIterator().next()));
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setBackground(parent.getBackground());
        Composite titleComposite = new Composite(composite, 0);
        titleComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label label = new Label(titleComposite, 0);
        label.setBackground(parent.getBackground());
        IItemPropertyDescriptor propDescriptor = this.getItemPropertyDescriptor(mainSetting);
        String labelText = "";
        if (propDescriptor != null) {
            labelText = propDescriptor.getDisplayName(null);
        }
        label.setText(labelText);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        this.validationIcon = this.createValidationIcon(titleComposite);
        GridDataFactory.fillDefaults().hint(16, 17).grab(false, false).applyTo((Control)this.validationIcon);
        Button addButton = null;
        Button removeButton = null;
        Composite buttonComposite = new Composite(titleComposite, 0);
        buttonComposite.setBackground(titleComposite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
        int numButtons = 2;
        if (((VTableControl)this.getVElement()).isEnableDetailEditingDialog()) {
            ++numButtons;
            this.createDetailEditButton(buttonComposite);
        }
        if (!tableControlConfiguration.isAddRemoveDisabled()) {
            addButton = this.createAddRowButton(clazz, buttonComposite, mainSetting);
            removeButton = this.createRemoveRowButton(clazz, buttonComposite, mainSetting);
        } else {
            numButtons -= 2;
        }
        GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(false).applyTo(buttonComposite);
        Composite controlComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, 200).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        this.tableViewer = this.createTableViewer(controlComposite, clazz, mainSetting, tableControlConfiguration);
        if (addButton != null && removeButton != null) {
            final Button finalAddButton = addButton;
            final Button finalRemoveButton = removeButton;
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableControlSWTRenderer.this.addRow(clazz, mainSetting);
                    List containments = (List)mainSetting.get(true);
                    if (mainSetting.getEStructuralFeature().getUpperBound() != -1 && containments.size() >= mainSetting.getEStructuralFeature().getUpperBound()) {
                        finalAddButton.setEnabled(false);
                    }
                    if (containments.size() > mainSetting.getEStructuralFeature().getLowerBound()) {
                        finalRemoveButton.setEnabled(true);
                    }
                }
            });
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)TableControlSWTRenderer.this.tableViewer.getSelection();
                    if (selection == null || selection.getFirstElement() == null) {
                        return;
                    }
                    ArrayList<EObject> deletionList = new ArrayList<EObject>();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        deletionList.add((EObject)iterator.next());
                    }
                    TableControlSWTRenderer.this.deleteRowUserConfirmDialog(deletionList, mainSetting, finalAddButton, finalRemoveButton);
                }
            });
        }
        return composite;
    }

    private VTableDomainModelReference getTableDomainModelReference() {
        VDomainModelReference vdmr = ((VTableControl)this.getVElement()).getDomainModelReference();
        if (VTableDomainModelReference.class.isInstance(vdmr)) {
            return (VTableDomainModelReference)VTableDomainModelReference.class.cast(vdmr);
        }
        EList contents = vdmr.eContents();
        for (EObject eObject : contents) {
            if (!VTableDomainModelReference.class.isInstance(eObject)) continue;
            return (VTableDomainModelReference)VTableDomainModelReference.class.cast(eObject);
        }
        return null;
    }

    private void createDetailEditButton(final Composite buttonComposite) {
        this.detailEditButton = new Button(buttonComposite, 8);
        this.detailEditButton.setImage(Activator.getImage("icons/detailEdit.png"));
        this.detailEditButton.setEnabled(false);
        this.detailEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (TableControlSWTRenderer.this.tableViewer.getSelection().isEmpty()) {
                    MessageDialog dialog = new MessageDialog(buttonComposite.getShell(), "No Table Selection", null, "You must select one element in order to edit it.", 4, new String[]{JFaceResources.getString((String)"ok")}, 0);
                    new ECPDialogExecutor((Dialog)dialog){

                        public void handleResult(int codeResult) {
                        }
                    }.execute();
                } else {
                    TableControlSWTRenderer.this.openDetailEditDialog(buttonComposite.getShell());
                }
            }
        });
    }

    private void openDetailEditDialog(Shell shell) {
        DetailDialog dialog = new DetailDialog(shell, (EObject)((IStructuredSelection)IStructuredSelection.class.cast(this.tableViewer.getSelection())).getFirstElement(), (VTableControl)this.getVElement());
        new ECPDialogExecutor(dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }

    private TableViewer createTableViewer(Composite composite, EClass clazz, EStructuralFeature.Setting mainSetting, TableControlConfiguration tableControlConfiguration) {
        TableViewer tableViewer = new TableViewer(composite, 68098);
        tableViewer.getTable().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new ECPFocusCellDrawHighlighter((ColumnViewer)tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getTable().setData(FIXED_COLUMNS, (Object)new Integer(1));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        InternalEObject tempInstance = this.getInstanceOf(clazz);
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        tableViewer.setComparator((ViewerComparator)comparator);
        int columnNumber = 0;
        Map<EStructuralFeature, Boolean> readOnlyConfig = this.createReadOnlyConfig(clazz, tableControlConfiguration);
        ArrayList<EStructuralFeature> structuralFeatures = new ArrayList<EStructuralFeature>();
        structuralFeatures.addAll(readOnlyConfig.keySet());
        if (!((VTableControl)this.getVElement()).isReadonly()) {
            this.createFixedValidationStatusColumn(tableViewer);
        }
        for (EStructuralFeature feature : structuralFeatures) {
            IItemPropertyDescriptor itemPropertyDescriptor;
            if (feature == null || (itemPropertyDescriptor = this.getItemPropertyDescriptor(tempInstance.eSetting(feature))) == null) continue;
            CellEditor cellEditor = this.createCellEditor((EObject)tempInstance, feature, tableViewer.getTable());
            TableViewerColumn column = TableViewerColumnBuilder.create().setText(itemPropertyDescriptor.getDisplayName(null)).setToolTipText(itemPropertyDescriptor.getDescription(null)).setResizable(true).setMoveable(false).setStyle(0).setData("width", (Object)(ECPCellEditor.class.isInstance(cellEditor) ? ((ECPCellEditor)ECPCellEditor.class.cast(cellEditor)).getColumnWidthWeight() : 100)).build(tableViewer);
            column.setLabelProvider((CellLabelProvider)new ECPCellLabelProvider(feature, cellEditor, (IObservableMap)(feature.isMany() ? new EObjectObservableMap(cp.getKnownElements(), feature) : EMFProperties.value((EStructuralFeature)feature).observeDetail(cp.getKnownElements())), (VTableControl)this.getVElement()));
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(tableViewer, comparator, column.getColumn(), columnNumber));
            if (!TableControlSWTRenderer.isReadOnlyFeature(readOnlyConfig, feature)) {
                ECPTableEditingSupport observableSupport = new ECPTableEditingSupport((ColumnViewer)tableViewer, cellEditor, feature, itemPropertyDescriptor, (VTableControl)this.getVElement());
                column.setEditingSupport((EditingSupport)observableSupport);
            }
            ++columnNumber;
        }
        tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getEditingDomain(mainSetting), (EObject)mainSetting.getEObject(), (EStructuralFeature)mainSetting.getEStructuralFeature());
        tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        int i = 0;
        while (i < tableViewer.getTable().getColumns().length) {
            Integer storedValue = (Integer)tableViewer.getTable().getColumns()[i].getData("width");
            layout.setColumnData((Widget)tableViewer.getTable().getColumns()[i], (ColumnLayoutData)new ColumnWeightData(storedValue == null ? 50 : storedValue));
            ++i;
        }
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    if (TableControlSWTRenderer.this.detailEditButton != null) {
                        TableControlSWTRenderer.this.detailEditButton.setEnabled(false);
                    }
                    if (TableControlSWTRenderer.this.removeButton != null) {
                        TableControlSWTRenderer.this.removeButton.setEnabled(false);
                    }
                } else {
                    if (TableControlSWTRenderer.this.detailEditButton != null && ((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() == 1) {
                        TableControlSWTRenderer.this.detailEditButton.setEnabled(true);
                    }
                    if (TableControlSWTRenderer.this.removeButton != null) {
                        TableControlSWTRenderer.this.removeButton.setEnabled(true);
                    }
                }
            }
        });
        return tableViewer;
    }

    private static boolean isReadOnlyFeature(Map<EStructuralFeature, Boolean> readOnlyConfig, EStructuralFeature feature) {
        Boolean isReadOnly;
        if (readOnlyConfig != null && (isReadOnly = readOnlyConfig.get(feature)) != null) {
            return isReadOnly;
        }
        return false;
    }

    private SelectionAdapter getSelectionAdapter(final TableViewer tableViewer, final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                tableViewer.getTable().setSortDirection(dir);
                tableViewer.getTable().setSortColumn(column);
                tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createFixedValidationStatusColumn(TableViewer tableViewer) {
        TableViewerColumn column = TableViewerColumnBuilder.create().setMoveable(false).setText(ControlMessages.TableControl_ValidationStatusColumn).setWidth(80).build(tableViewer);
        column.setLabelProvider((CellLabelProvider)new ValidationStatusCellLabelProvider((VTableControl)this.getVElement()));
    }

    private CellEditor createCellEditor(EObject tempInstance, EStructuralFeature feature, Table table) {
        return CellEditorFactory.INSTANCE.getCellEditor(feature, tempInstance, table, this.getViewModelContext());
    }

    private InternalEObject getInstanceOf(EClass clazz) {
        return (InternalEObject)InternalEObject.class.cast(clazz.getEPackage().getEFactoryInstance().create(clazz));
    }

    private Map<EStructuralFeature, Boolean> createReadOnlyConfig(EClass clazz, TableControlConfiguration tableControlConfiguration) {
        LinkedHashMap<EStructuralFeature, Boolean> readOnlyConfig = new LinkedHashMap<EStructuralFeature, Boolean>();
        for (TableColumnConfiguration tcc : tableControlConfiguration.getColumns()) {
            readOnlyConfig.put((EStructuralFeature)tcc.getColumnAttribute(), tcc.isReadOnly());
        }
        return readOnlyConfig;
    }

    private Button createRemoveRowButton(EClass clazz, Composite buttonComposite, EStructuralFeature.Setting mainSetting) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage(ICON_DELETE);
        this.removeButton.setImage(image);
        this.removeButton.setEnabled(false);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.removeButton.setToolTipText(String.format(ControlMessages.TableControl_RemoveSelected, instanceName));
        List containments = (List)mainSetting.get(true);
        if (containments.size() <= mainSetting.getEStructuralFeature().getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
        return this.removeButton;
    }

    private Button createAddRowButton(EClass clazz, Composite buttonComposite, EStructuralFeature.Setting mainSetting) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage(ICON_ADD);
        this.addButton.setImage(image);
        String instanceName = clazz.getInstanceClass() == null ? "" : clazz.getInstanceClass().getSimpleName();
        this.addButton.setToolTipText(String.format(ControlMessages.TableControl_AddInstanceOf, instanceName));
        List containments = (List)mainSetting.get(true);
        if (mainSetting.getEStructuralFeature().getUpperBound() != -1 && containments.size() >= mainSetting.getEStructuralFeature().getUpperBound()) {
            this.addButton.setEnabled(false);
        }
        return this.addButton;
    }

    protected void deleteRowUserConfirmDialog(final List<EObject> deletionList, final EStructuralFeature.Setting mainSetting, final Button addButton, final Button removeButton) {
        MessageDialog dialog = new MessageDialog(addButton.getShell(), ControlMessages.TableControl_Delete, null, ControlMessages.TableControl_DeleteAreYouSure, 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
                if (codeResult == 1) {
                    return;
                }
                TableControlSWTRenderer.this.deleteRows(deletionList, mainSetting);
                List containments = (List)mainSetting.get(true);
                if (containments.size() < mainSetting.getEStructuralFeature().getUpperBound()) {
                    addButton.setEnabled(true);
                }
                if (containments.size() <= mainSetting.getEStructuralFeature().getLowerBound()) {
                    removeButton.setEnabled(false);
                }
            }
        }.execute();
    }

    protected void deleteRows(List<EObject> deletionList, EStructuralFeature.Setting mainSetting) {
        EObject modelElement = mainSetting.getEObject();
        EditingDomain editingDomain = this.getEditingDomain(mainSetting);
        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)mainSetting.getEStructuralFeature(), deletionList));
    }

    protected void addRow(EClass clazz, EStructuralFeature.Setting mainSetting) {
        EObject modelElement = mainSetting.getEObject();
        EObject instance = clazz.getEPackage().getEFactoryInstance().create(clazz);
        EditingDomain editingDomain = this.getEditingDomain(mainSetting);
        if (editingDomain == null) {
            return;
        }
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)mainSetting.getEStructuralFeature(), (Object)instance));
    }

    protected void applyValidation() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableControlSWTRenderer.this.validationIcon == null) {
                    return;
                }
                if (TableControlSWTRenderer.this.validationIcon.isDisposed()) {
                    return;
                }
                if (((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic() == null) {
                    return;
                }
                TableControlSWTRenderer.this.validationIcon.setImage(TableControlSWTRenderer.this.getValidationIcon(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getHighestSeverity()));
                TableControlSWTRenderer.this.validationIcon.setToolTipText(((VTableControl)TableControlSWTRenderer.this.getVElement()).getDiagnostic().getMessage());
                EStructuralFeature.Setting mainSetting = (EStructuralFeature.Setting)((VTableControl)TableControlSWTRenderer.this.getVElement()).getDomainModelReference().getIterator().next();
                Collection collection = (Collection)mainSetting.get(true);
                if (!collection.isEmpty()) {
                    for (Object object : collection) {
                        TableControlSWTRenderer.this.tableViewer.update(object, null);
                    }
                }
            }
        });
    }

    protected void applyEnable() {
        if (this.addButton != null) {
            this.addButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void applyReadOnly() {
        if (this.addButton != null) {
            this.addButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
        if (this.removeButton != null) {
            this.removeButton.setVisible(((VTableControl)this.getVElement()).isEnabled() && !((VTableControl)this.getVElement()).isReadonly());
        }
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    public class ECPCellLabelProvider
    extends ObservableMapCellLabelProvider
    implements IColorProvider {
        private final EStructuralFeature feature;
        private final CellEditor cellEditor;
        private final VTableControl vTableControl;

        public ECPCellLabelProvider(EStructuralFeature feature, CellEditor cellEditor, IObservableMap attributeMap, VTableControl vTableControl) {
            super(attributeMap);
            this.vTableControl = vTableControl;
            this.feature = feature;
            this.cellEditor = cellEditor;
        }

        public String getToolTipText(Object element) {
            EObject domainObject = (EObject)element;
            EStructuralFeature.Setting setting = ((InternalEObject)InternalEObject.class.cast(domainObject)).eSetting(this.feature);
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostic(domainObject, this.feature);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            if (tooltip.length() != 0) {
                return ECPTooltipModifierHelper.modifyString((String)tooltip.toString(), (EStructuralFeature.Setting)setting);
            }
            Object value = ((EObject)element).eGet(this.feature);
            if (value == null) {
                return null;
            }
            return ECPTooltipModifierHelper.modifyString((String)String.valueOf(value), (EStructuralFeature.Setting)setting);
        }

        public void update(ViewerCell cell) {
            EObject element = (EObject)cell.getElement();
            Object value = this.attributeMaps[0].get((Object)element);
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ECPCellEditor ecpCellEditor = (ECPCellEditor)this.cellEditor;
                String text = ecpCellEditor.getFormatedString(value);
                cell.setText(text == null ? "" : text);
            } else {
                cell.setText(value == null ? "" : value.toString());
                cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
            }
            cell.setBackground(this.getBackground(element));
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return TableControlSWTRenderer.this.getValidationBackgroundColor(0);
            }
            List diagnostic = vDiagnostic.getDiagnostic((EObject)element, this.feature);
            return TableControlSWTRenderer.this.getValidationBackgroundColor(diagnostic.size() == 0 ? 0 : ((Diagnostic)diagnostic.get(0)).getSeverity());
        }
    }

    private class ECPTableEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final EStructuralFeature cellFeature;
        private final IItemPropertyDescriptor itemPropertyDescriptor;
        private final VTableControl tableControl;
        private EditingState editingState;
        private final ColumnViewerEditorActivationListenerHelper activationListener;

        public ECPTableEditingSupport(ColumnViewer viewer, CellEditor cellEditor, EStructuralFeature feature, IItemPropertyDescriptor itemPropertyDescriptor, VTableControl tableControl) {
            super(viewer);
            this.activationListener = new ColumnViewerEditorActivationListenerHelper();
            this.cellEditor = cellEditor;
            this.cellFeature = feature;
            this.itemPropertyDescriptor = itemPropertyDescriptor;
            this.tableControl = tableControl;
        }

        protected boolean canEdit(Object element) {
            boolean editable = this.itemPropertyDescriptor.canSetProperty(null) && this.tableControl.isEnabled() && !this.tableControl.isReadonly();
            editable &= !CellReadOnlyTesterHelper.getInstance().isReadOnly((VTableControl)TableControlSWTRenderer.this.getVElement(), ((InternalEObject)InternalEObject.class.cast(element)).eSetting(this.cellFeature));
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                ((ECPCellEditor)ECPCellEditor.class.cast(this.cellEditor)).setEditable(editable);
                return true;
            }
            return editable;
        }

        protected Object getValue(Object element) {
            return null;
        }

        protected void setValue(Object element, Object value) {
        }

        protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            IObservableValue target = this.doCreateCellEditorObservable(cellEditor);
            Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
            IObservableValue model = this.doCreateElementObservable(cell.getElement(), cell);
            Assert.isNotNull((Object)model, (String)"doCreateElementObservable(...) did not return an observable");
            Binding binding = this.createBinding(target, model);
            Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
            this.editingState = new EditingState(binding, target, model);
            this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            if (ECPCellEditor.class.isInstance(this.cellEditor)) {
                return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)this.cellEditor).getTargetToModelStrategy(), ((ECPCellEditor)this.cellEditor).getModelToTargetStrategy());
            }
            return TableControlSWTRenderer.this.getDataBindingContext().bindValue(target, model);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            return EMFEditObservables.observeValue((EditingDomain)TableControlSWTRenderer.this.getEditingDomain(((InternalEObject)InternalEObject.class.cast(element)).eSetting(this.cellFeature)), (EObject)((EObject)element), (EStructuralFeature)this.cellFeature);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                return ((ECPCellEditor)cellEditor).getValueProperty().observe((Object)cellEditor);
            }
            return SWTObservables.observeText((Control)cellEditor.getControl(), (int)16);
        }

        protected final void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
            this.editingState.binding.updateTargetToModel();
        }

        private class ColumnViewerEditorActivationListenerHelper
        extends ColumnViewerEditorActivationListener {
            private ColumnViewerEditorActivationListenerHelper() {
            }

            public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                ECPTableEditingSupport.this.editingState.dispose();
                ECPTableEditingSupport.this.editingState = null;
                ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                ViewerCell focusCell = ECPTableEditingSupport.this.getViewer().getColumnViewerEditor().getFocusCell();
                if (focusCell != null) {
                    ECPTableEditingSupport.this.getViewer().update(focusCell.getElement(), null);
                }
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
            }
        }

        class EditingState {
            private final IObservableValue target;
            private final IObservableValue model;
            private final Binding binding;

            EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                this.binding = binding;
                this.target = target;
                this.model = model;
            }

            void dispose() {
                this.binding.dispose();
                this.target.dispose();
                this.model.dispose();
            }
        }
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            EStructuralFeature feat1 = (EStructuralFeature)object1.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            EStructuralFeature feat2 = (EStructuralFeature)object2.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            Object value1 = object1.eGet(feat1);
            Object value2 = object2.eGet(feat2);
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class ValidationStatusCellLabelProvider
    extends CellLabelProvider {
        private final VTableControl vTableControl;

        public ValidationStatusCellLabelProvider(VTableControl vTableControl) {
            this.vTableControl = vTableControl;
        }

        public void update(ViewerCell cell) {
            Integer mostSevere = 0;
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            if (vDiagnostic == null) {
                return;
            }
            List diagnostics = vDiagnostic.getDiagnostics((EObject)cell.getElement());
            if (diagnostics.size() != 0) {
                mostSevere = ((Diagnostic)diagnostics.get(0)).getSeverity();
            }
            cell.setImage(TableControlSWTRenderer.this.getValidationIcon(mostSevere));
        }

        public String getToolTipText(Object element) {
            StringBuffer tooltip = new StringBuffer();
            VDiagnostic vDiagnostic = this.vTableControl.getDiagnostic();
            List diagnostics = vDiagnostic.getDiagnostics((EObject)element);
            for (Diagnostic diagnostic : diagnostics) {
                if (tooltip.length() > 0) {
                    tooltip.append("\n");
                }
                tooltip.append(diagnostic.getMessage());
            }
            return tooltip.toString();
        }
    }
}

