/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.e4.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DynamicCreateChildrenElementsMenuContribution {
    @Inject
    private ESelectionService selectionService;

    public List<?> getSelectedObjects() {
        Object sel = this.selectionService.getSelection();
        if (sel != null) {
            if (sel instanceof Collection) {
                Collection col = (Collection)sel;
                return new ArrayList(col);
            }
            if (sel instanceof Object[]) {
                return Arrays.asList((Object[])sel);
            }
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)sel;
                return ssel.toList();
            }
            return Arrays.asList(sel);
        }
        return null;
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items) {
        List<?> selectedObjects = this.getSelectedObjects();
        if (selectedObjects == null || selectedObjects.isEmpty()) {
            return;
        }
        Object[] elements = selectedObjects.toArray();
        if (elements.length == 1 && elements[0] instanceof EObject) {
            EObject eObject = (EObject)elements[0];
            ECPProject project = ECPUtil.getECPProjectManager().getProject((Object)eObject);
            EditingDomain domain = project.getEditingDomain();
            Collection childDescriptors = new ChildrenDescriptorCollector().getDescriptors(eObject);
            for (Object childDescriptor : childDescriptors) {
                CommandParameter cp = (CommandParameter)childDescriptor;
                if (cp.getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
                final CustomCreateChildAction createChildAction = new CustomCreateChildAction(domain, (ISelection)new StructuredSelection((Object)eObject), childDescriptor, cp, project);
                MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
                dynamicItem.setLabel(createChildAction.getText());
                dynamicItem.setTooltip(createChildAction.getToolTipText());
                dynamicItem.setObject(new Object(){

                    @Execute
                    public void execute(MDirectMenuItem me) {
                        createChildAction.run();
                    }
                });
                dynamicItem.setIconURI(createChildAction.getImageURIString());
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private final class CustomCreateChildAction
    extends CreateChildAction {
        private final CommandParameter cp;
        private final ECPProject project;

        private CustomCreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor, CommandParameter cp, ECPProject project) {
            super(editingDomain, selection, descriptor);
            this.cp = cp;
            this.project = project;
        }

        public void run() {
            super.run();
            ECPHandlerHelper.openModelElement((Object)this.cp.getEValue(), (ECPProject)this.project);
        }

        private String getImageURIString() {
            CommandActionDelegate commandActionDelegate = (CommandActionDelegate)this.command;
            Object image = commandActionDelegate.getImage();
            if (ComposedImage.class.isInstance(image)) {
                ComposedImage composedImage = (ComposedImage)image;
                Object subImage = composedImage.getImages().get(0);
                return subImage.toString();
            }
            return image.toString();
        }
    }
}

