/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.util.DateUtil;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.RendererMessages;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLDateControlSWTRenderer
extends TextControlSWTRenderer {
    public XMLDateControlSWTRenderer() {
    }

    XMLDateControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    @Override
    protected Control createSWTControl(Composite parent, EStructuralFeature.Setting setting) {
        Composite main = new Composite(parent, 0);
        main.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        Control text = super.createSWTControl(main, setting);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo(text);
        Button bDate = new Button(main, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bDate);
        bDate.setImage(Activator.getImage("icons/date.png"));
        bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_xmldate");
        return main;
    }

    @Override
    protected String getTextMessage(EStructuralFeature.Setting setting) {
        return ((SimpleDateFormat)this.setupFormat()).toPattern();
    }

    @Override
    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_control_xmldate";
    }

    @Override
    protected Binding[] createBindings(Control control, EStructuralFeature.Setting setting) {
        Text text = (Text)((Composite)control).getChildren()[0];
        Button button = (Button)((Composite)control).getChildren()[1];
        button.addSelectionListener((SelectionListener)new SelectionAdapterExtension(text, button, this.getModelValue(setting), this.getViewModelContext(), this.getDataBindingContext(), setting.getEStructuralFeature()));
        ISWTObservableValue value = SWTObservables.observeText((Control)text, (int)16);
        DateTargetToModelUpdateStrategy targetToModelUpdateStrategy = new DateTargetToModelUpdateStrategy(setting.getEStructuralFeature(), this.getModelValue(setting), this.getDataBindingContext(), text);
        DateModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new DateModelToTargetUpdateStrategy(false);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(setting), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        Binding tooltipBinding = this.createTooltipBinding(control, this.getModelValue(setting), this.getDataBindingContext(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(true));
        return new Binding[]{binding, tooltipBinding};
    }

    protected DateFormat setupFormat() {
        return DateFormat.getDateInstance(2, this.getLocale(this.getViewModelContext()));
    }

    private Locale getLocale(ViewModelContext viewModelContext) {
        ViewLocaleService service = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        if (service == null) {
            return Locale.getDefault();
        }
        return service.getLocale();
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        ((Composite)control).getChildren()[0].setBackground(validationColor);
    }

    @Override
    protected void setControlEnabled(SWTGridCell gridCell, Control control, boolean enabled) {
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.NONE && gridCell.getColumn() == 1 || ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT && gridCell.getColumn() == 2) {
            ((Text)((Composite)control).getChildren()[0]).setEditable(enabled);
            ((Button)((Composite)control).getChildren()[1]).setVisible(enabled);
        } else {
            super.setControlEnabled(gridCell, control, enabled);
        }
    }

    @Override
    protected String getUnsetText() {
        return RendererMessages.XmlDateControlText_NoDateSetClickToSetDate;
    }

    private class DateModelToTargetUpdateStrategy
    extends TextControlSWTRenderer.ModelToTargetUpdateStrategy {
        public DateModelToTargetUpdateStrategy(boolean tooltip) {
            super(XMLDateControlSWTRenderer.this, tooltip);
        }

        @Override
        public Object convertValue(Object value) {
            DateFormat format = XMLDateControlSWTRenderer.this.setupFormat();
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)value;
            if (gregorianCalendar == null) {
                return null;
            }
            Date date = gregorianCalendar.toGregorianCalendar().getTime();
            return format.format(date);
        }
    }

    private class DateTargetToModelUpdateStrategy
    extends TextControlSWTRenderer.TargetToModelUpdateStrategy {
        private final EStructuralFeature eStructuralFeature;
        private final Text text;
        private final IObservableValue modelValue;

        DateTargetToModelUpdateStrategy(EStructuralFeature eStructuralFeature, IObservableValue modelValue, DataBindingContext dataBindingContext, Text text) {
            super(XMLDateControlSWTRenderer.this, eStructuralFeature.isUnsettable());
            this.eStructuralFeature = eStructuralFeature;
            this.modelValue = modelValue;
            this.text = text;
        }

        @Override
        protected Object convertValue(Object value) {
            try {
                Date date = null;
                if (String.class.isInstance(value)) {
                    date = XMLDateControlSWTRenderer.this.setupFormat().parse((String)value);
                } else if (Date.class.isInstance(value)) {
                    date = (Date)value;
                } else if (value == null) {
                    return value;
                }
                String formatedDate = XMLDateControlSWTRenderer.this.setupFormat().format(date);
                this.text.setText(formatedDate);
                Calendar targetCal = Calendar.getInstance();
                targetCal.setTime(date);
                return DateUtil.convertOnlyDateToXMLGregorianCalendar((Calendar)targetCal);
            }
            catch (ParseException parseException) {
                return this.revertToOldValue(value);
            }
        }

        private Object revertToOldValue(Object value) {
            if (this.eStructuralFeature.getDefaultValue() == null && (value == null || value.equals(""))) {
                return null;
            }
            Object result = this.modelValue.getValue();
            MessageDialog messageDialog = new MessageDialog(this.text.getShell(), ControlMessages.XmlDateControlText_InvalidNumber, null, ControlMessages.XmlDateControlText_NumberInvalidValueWillBeUnset, 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
            new ECPDialogExecutor((Dialog)messageDialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
            XMLDateControlSWTRenderer.this.getDataBindingContext().updateTargets();
            if (this.eStructuralFeature.isUnsettable() && result == null) {
                return SetCommand.UNSET_VALUE;
            }
            return result;
        }
    }

    private final class SelectionAdapterExtension
    extends SelectionAdapter {
        private final Control button;
        private final IObservableValue modelValue;
        private final ViewModelContext viewModelContext;
        private final DataBindingContext dataBindingContext;
        private final Text text;
        private final EStructuralFeature eStructuralFeature;

        private SelectionAdapterExtension(Text text, Button button, IObservableValue modelValue, ViewModelContext viewModelContext, DataBindingContext dataBindingContext, EStructuralFeature eStructuralFeature) {
            this.text = text;
            this.button = button;
            this.modelValue = modelValue;
            this.viewModelContext = viewModelContext;
            this.dataBindingContext = dataBindingContext;
            this.eStructuralFeature = eStructuralFeature;
        }

        public void widgetSelected(SelectionEvent e) {
            final Shell dialog = new Shell(this.button.getShell(), 0);
            dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)dialog, 3072);
            XMLGregorianCalendar gregorianCalendar = (XMLGregorianCalendar)this.modelValue.getValue();
            Calendar cal = Calendar.getInstance(XMLDateControlSWTRenderer.this.getLocale(this.viewModelContext));
            if (gregorianCalendar != null) {
                cal.setTime(gregorianCalendar.toGregorianCalendar().getTime());
            }
            calendar.setDate(cal.get(1), cal.get(2), cal.get(5));
            ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)calendar);
            final Binding binding = this.dataBindingContext.bindValue((IObservableValue)dateObserver, this.modelValue, (UpdateValueStrategy)new DateTargetToModelUpdateStrategy(this.eStructuralFeature, this.modelValue, this.dataBindingContext, this.text), (UpdateValueStrategy)new DateModelToTargetUpdateStrategy(false));
            binding.updateModelToTarget();
            calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                }
            });
            calendar.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent event) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                }

                public void focusGained(FocusEvent event) {
                }
            });
            dialog.pack();
            dialog.layout();
            dialog.setLocation(this.button.getParent().toDisplay(this.button.getLocation().x + this.button.getSize().x - dialog.getSize().x, this.button.getLocation().y + this.button.getSize().y));
            dialog.open();
        }
    }
}

