/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.EMFUtils;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.CompositeProvider;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.internal.swt.Messages;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultReferenceService
implements ReferenceService {
    private EObject rootDomainModel;
    private EditingDomain editingDomain;

    public void instantiate(ViewModelContext context) {
        this.rootDomainModel = context.getDomainModel();
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.rootDomainModel);
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void addModelElement(EObject eObject, EReference eReference) {
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        ECPControlHelper.addModelElementInReference((EObject)this.rootDomainModel, (EObject)eObject, (EReference)eReference, (EditingDomain)this.editingDomain);
    }

    public EObject getNewElementFor(EReference eReference) {
        Collection classes = EMFUtils.getSubClasses((EClass)eReference.getEReferenceType());
        SelectModelElementWizard wizard = new SelectModelElementWizard("New Reference Element", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement);
        SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
        wizard.setCompositeProvider((CompositeProvider)helper);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EObject newMEInstance = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = helper.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            EClass eClasse = (EClass)selection[0];
            EPackage ePackage = eClasse.getEPackage();
            newMEInstance = ePackage.getEFactoryInstance().create(eClasse);
        }
        if (newMEInstance == null) {
            return null;
        }
        return newMEInstance;
    }

    public EObject getExistingElementFor(EReference eReference) {
        Iterator allElements = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)this.rootDomainModel, (EClassifier)eReference.getEType()).iterator();
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        SelectModelElementWizard wizard = new SelectModelElementWizard("Select Elements", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.ModelelementSelectionDialog_DialogTitle, Messages.ModelelementSelectionDialog_DialogMessage_SearchPattern, EObject.class);
        SelectionComposite tableSelectionComposite = CompositeFactory.getTableSelectionComposite((Object)elements.toArray());
        wizard.setCompositeProvider((CompositeProvider)tableSelectionComposite);
        WizardDialog wd = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        EObject eObject = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = tableSelectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            eObject = (EObject)selection[0];
        }
        return eObject;
    }

    public void openInNewContext(final EObject eObject) {
        Dialog dialog = new Dialog(Display.getDefault().getActiveShell()){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                try {
                    ECPSWTViewRenderer.INSTANCE.render(composite, eObject);
                }
                catch (ECPRendererException ex) {
                    Activator.log((Exception)((Object)ex));
                }
                return composite;
            }
        };
        new ECPDialogExecutor(dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }
}

