/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.Calendar;
import java.util.Locale;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ViewLocaleService;
import org.eclipse.emf.ecp.view.internal.core.swt.Activator;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.RendererMessages;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateTimeControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private Label unsetLabel;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite dateTimeComposite;
    private Composite composite;
    private EStructuralFeature.Setting setting;
    private ModelChangeListener domainModelChangeListener;

    public DateTimeControlSWTRenderer() {
    }

    DateTimeControlSWTRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    @Override
    protected Binding[] createBindings(Control control, final EStructuralFeature.Setting setting) {
        this.setting = setting;
        DateTime date = (DateTime)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[0];
        DateTime time = (DateTime)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[1];
        Button unsetBtn = (Button)((Composite)((Composite)((Composite)control).getChildren()[0]).getChildren()[0]).getChildren()[2];
        Button setBtn = (Button)((Composite)control).getChildren()[1];
        ISWTObservableValue dateObserver = SWTObservables.observeSelection((Control)date);
        ISWTObservableValue timeObserver = SWTObservables.observeSelection((Control)time);
        DateAndTimeObservableValue target = new DateAndTimeObservableValue((IObservableValue)dateObserver, (IObservableValue)timeObserver);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)target, this.getModelValue(setting));
        setBtn.addSelectionListener((SelectionListener)new SetBtnSelectionAdapterExtension(setBtn, this.getModelValue(setting), this.getViewModelContext()));
        unsetBtn.addSelectionListener((SelectionListener)new UnsetBtnSelectionAdapterExtension());
        this.domainModelChangeListener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (setting.getEStructuralFeature().equals(notification.getStructuralFeature())) {
                    DateTimeControlSWTRenderer.this.updateChangeListener(notification.getRawNotification().getNewValue());
                }
            }
        };
        this.getViewModelContext().registerDomainChangeListener(this.domainModelChangeListener);
        return new Binding[]{binding};
    }

    @Override
    protected void dispose() {
        this.getViewModelContext().unregisterDomainChangeListener(this.domainModelChangeListener);
        super.dispose();
    }

    @Override
    protected Control createSWTControl(Composite parent, EStructuralFeature.Setting setting) {
        this.composite = new Composite(parent, 0);
        this.composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).equalWidth(false).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.composite);
        this.stackComposite = new Composite(this.composite, 0);
        this.stackComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(2, 0).equalWidth(false).applyTo(this.stackComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.stackComposite);
        this.dateTimeComposite = new Composite(this.stackComposite, 0);
        this.dateTimeComposite.setBackground(this.composite.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(2, 0).equalWidth(false).applyTo(this.dateTimeComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.dateTimeComposite);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.unsetLabel = new Label(this.stackComposite, 0x1000000);
        this.unsetLabel.setText(this.getUnsetText());
        this.unsetLabel.setBackground(this.stackComposite.getBackground());
        this.unsetLabel.setForeground(parent.getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        DateTime dateWidget = new DateTime(this.dateTimeComposite, 2080);
        dateWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        dateWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_date");
        DateTime timeWidget = new DateTime(this.dateTimeComposite, 34944);
        timeWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        timeWidget.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_time");
        Button bUnset = new Button(this.dateTimeComposite, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bUnset);
        bUnset.setImage(Activator.getImage("icons/delete.png"));
        bUnset.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonUnset");
        bUnset.setToolTipText(RendererMessages.DateTimeControlSWTRenderer_CleanDate);
        Button bDate = new Button(this.composite, 8);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)bDate);
        bDate.setImage(Activator.getImage("icons/date.png"));
        bDate.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_dateTime_buttonSet");
        bDate.setToolTipText(RendererMessages.DateTimeControlSWTRenderer_SelectData);
        this.stackLayout.topControl = setting.isSet() ? this.dateTimeComposite : this.unsetLabel;
        return this.composite;
    }

    @Override
    protected void setValidationColor(Control control, Color validationColor) {
        ((Composite)control).getChildren()[0].setBackground(validationColor);
        ((Composite)control).getChildren()[1].setBackground(validationColor);
    }

    @Override
    protected String getUnsetText() {
        return RendererMessages.DateTimeControl_NoDateSetClickToSetDate;
    }

    private Locale getLocale(ViewModelContext viewModelContext) {
        ViewLocaleService service = (ViewLocaleService)viewModelContext.getService(ViewLocaleService.class);
        if (service == null) {
            return Locale.getDefault();
        }
        return service.getLocale();
    }

    private void updateChangeListener(Object value) {
        if (value == null) {
            if (this.stackLayout.topControl != this.unsetLabel) {
                this.stackLayout.topControl = this.unsetLabel;
                this.stackComposite.layout();
            }
        } else if (this.stackLayout.topControl != this.dateTimeComposite) {
            this.stackLayout.topControl = this.dateTimeComposite;
            this.stackComposite.layout();
        }
    }

    private class SetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private final Button btn;
        private final IObservableValue modelValue;
        private final ViewModelContext viewModelContext;

        public SetBtnSelectionAdapterExtension(Button btn, IObservableValue modelValue, ViewModelContext viewModelContext) {
            this.btn = btn;
            this.modelValue = modelValue;
            this.viewModelContext = viewModelContext;
        }

        public void widgetSelected(SelectionEvent e) {
            final Shell dialog = new Shell(this.btn.getShell(), 0);
            dialog.setLayout((Layout)new GridLayout(1, false));
            DateTime calendar = new DateTime((Composite)dialog, 3072);
            Calendar defaultCalendar = Calendar.getInstance(DateTimeControlSWTRenderer.this.getLocale(this.viewModelContext));
            calendar.setDate(defaultCalendar.get(1), defaultCalendar.get(2), defaultCalendar.get(5));
            ISWTObservableValue calendarObserver = SWTObservables.observeSelection((Control)calendar);
            UpdateValueStrategy modelToTarget = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            UpdateValueStrategy targetToModel = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
            final Binding binding = DateTimeControlSWTRenderer.this.getDataBindingContext().bindValue((IObservableValue)calendarObserver, this.modelValue, modelToTarget, targetToModel);
            binding.updateModelToTarget();
            calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                    DateTimeControlSWTRenderer.this.updateChangeListener(SetBtnSelectionAdapterExtension.this.modelValue.getValue());
                }
            });
            calendar.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent event) {
                    binding.updateTargetToModel();
                    binding.dispose();
                    dialog.close();
                    DateTimeControlSWTRenderer.this.updateChangeListener(SetBtnSelectionAdapterExtension.this.modelValue.getValue());
                }

                public void focusGained(FocusEvent event) {
                }
            });
            dialog.pack();
            dialog.layout();
            dialog.setLocation(this.btn.getParent().toDisplay(this.btn.getLocation().x + this.btn.getSize().x - dialog.getSize().x, this.btn.getLocation().y + this.btn.getSize().y));
            dialog.open();
        }
    }

    private class UnsetBtnSelectionAdapterExtension
    extends SelectionAdapter {
        private UnsetBtnSelectionAdapterExtension() {
        }

        public void widgetSelected(SelectionEvent e) {
            Command removeCommand = SetCommand.create((EditingDomain)DateTimeControlSWTRenderer.this.getEditingDomain(DateTimeControlSWTRenderer.this.setting), (Object)DateTimeControlSWTRenderer.this.setting.getEObject(), (Object)DateTimeControlSWTRenderer.this.setting.getEStructuralFeature(), null);
            DateTimeControlSWTRenderer.this.getEditingDomain(DateTimeControlSWTRenderer.this.setting).getCommandStack().execute(removeCommand);
            DateTimeControlSWTRenderer.this.updateChangeListener(DateTimeControlSWTRenderer.this.getModelValue(DateTimeControlSWTRenderer.this.setting).getValue());
        }
    }
}

