/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecp.view.internal.section.ui.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.section.model.VSectionedArea;
import org.eclipse.emf.ecp.view.spi.section.swt.SectionLeafSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractAdditionalSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SectionedAreaSWTRenderer
extends AbstractSWTRenderer<VSectionedArea> {
    private static final String CUSTOM_VARIANT_VALUE = "org_eclipse_emf_ecp_ui_section";
    private SWTGridDescription gridDescription;

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.gridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        SWTGridDescription gridDescription;
        if (gridCell.getColumn() != 0) {
            return null;
        }
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)CUSTOM_VARIANT_VALUE);
        columnComposite.setBackground(parent.getBackground());
        SWTGridDescription maximalGridDescription = null;
        SWTGridDescription rowGridDescription = null;
        SWTGridDescription controlGridDescription = null;
        VSection child = ((VSectionedArea)this.getVElement()).getRoot();
        AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer((VElement)child, this.getViewModelContext());
        if (renderer == null) {
            return columnComposite;
        }
        Collection additionalRenderers = this.getSWTRendererFactory().getAdditionalRenderer((VElement)child, this.getViewModelContext());
        controlGridDescription = gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
            gridDescription = additionalRenderer.getGridDescription(gridDescription);
        }
        rowGridDescription = gridDescription;
        maximalGridDescription = gridDescription;
        LinkedHashSet<AbstractSWTRenderer> allRenderer = new LinkedHashSet<AbstractSWTRenderer>();
        allRenderer.add(renderer);
        allRenderer.addAll(additionalRenderers);
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(LayoutProviderHelper.getColumnLayout((int)maximalGridDescription.getColumns(), (boolean)false));
        try {
            SWTGridDescription gridDescription2 = rowGridDescription;
            if (gridDescription2 == null) {
                return columnComposite;
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                if (control == null) continue;
                this.setLayoutDataForControl(childGridCell, controlGridDescription, gridDescription2, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        catch (NoPropertyDescriptorFoundExeption ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        return columnComposite;
    }

    protected void setLayoutDataForControl(SWTGridCell gridCell, SWTGridDescription gridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, Control control) {
        Object layoutData = LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (Control)control);
        if (!GridData.class.isInstance(layoutData)) {
            return;
        }
        if (gridCell.getColumn() == 0) {
            ((GridData)GridData.class.cast((Object)layoutData)).widthHint = 300;
        } else if (gridCell.getColumn() == 1) {
            ((GridData)GridData.class.cast((Object)layoutData)).widthHint = 20;
        } else if (gridCell.getColumn() == 2) {
            ((GridData)GridData.class.cast((Object)layoutData)).widthHint = 20;
        } else if (gridCell.getColumn() == 3) {
            if (SectionLeafSWTRenderer.class.isInstance(gridCell.getRenderer())) {
                ((GridData)GridData.class.cast((Object)layoutData)).grabExcessHorizontalSpace = false;
                ((GridData)GridData.class.cast((Object)layoutData)).horizontalAlignment = 1;
            }
            ((GridData)GridData.class.cast((Object)layoutData)).widthHint = 500;
        }
        control.setLayoutData(layoutData);
    }
}

