/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt;

import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.internal.table.swt.Activator;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.swt.DetailDialog;
import org.eclipse.emf.ecp.view.spi.table.swt.TableControlSWTRenderer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class TableControlDetailDialogSWTRenderer
extends TableControlSWTRenderer {
    private Button detailEditButton;
    private VView view;

    @Override
    protected int addButtonsToButtonBar(Composite buttonComposite) {
        this.createDetailEditButton(buttonComposite);
        return 1;
    }

    private void createDetailEditButton(Composite buttonComposite) {
        this.detailEditButton = new Button(buttonComposite, 8);
        this.detailEditButton.setImage(Activator.getImage("icons/detailEdit.png"));
        this.detailEditButton.setEnabled(false);
        this.detailEditButton.addSelectionListener((SelectionListener)new DetailEditButtonSelectionAdapter(buttonComposite.getShell()));
    }

    private VView getView() {
        if (this.view == null) {
            VView detailView = ((VTableControl)this.getVElement()).getDetailView();
            if (detailView == null) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VTableControl)this.getVElement()).getDomainModelReference().getIterator().next();
                EReference reference = (EReference)setting.getEStructuralFeature();
                detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), Collections.emptyMap());
            }
            this.view = detailView;
        }
        return (VView)EcoreUtil.copy((EObject)this.view);
    }

    @Override
    protected void viewerSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            if (this.detailEditButton != null) {
                this.detailEditButton.setEnabled(false);
            }
        } else if (this.detailEditButton != null && ((IStructuredSelection)IStructuredSelection.class.cast(event.getSelection())).size() == 1) {
            this.detailEditButton.setEnabled(true);
        }
        super.viewerSelectionChanged(event);
    }

    @Override
    protected void dispose() {
        this.detailEditButton = null;
        super.dispose();
    }

    private class DetailEditButtonSelectionAdapter
    extends SelectionAdapter {
        private final Shell shell;

        public DetailEditButtonSelectionAdapter(Shell shell) {
            this.shell = shell;
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            Dialog dialog = this.createDialog();
            new ECPDialogExecutor(dialog){

                public void handleResult(int codeResult) {
                }
            }.execute();
        }

        private Dialog createDialog() {
            Object dialog = TableControlDetailDialogSWTRenderer.this.getTableViewer().getSelection().isEmpty() ? new MessageDialog(this.shell, "No Table Selection", null, "You must select one element in order to edit it.", 4, new String[]{JFaceResources.getString((String)"ok")}, 0) : (TableControlDetailDialogSWTRenderer.this.getView() == null ? new MessageDialog(this.shell, "No View Model", null, "Detail editing is not possible since there is no UI description for the selection.", 1, new String[]{JFaceResources.getString((String)"ok")}, 0) : new DetailDialog(this.shell, (EObject)((IStructuredSelection)IStructuredSelection.class.cast(TableControlDetailDialogSWTRenderer.this.getTableViewer().getSelection())).getFirstElement(), (VTableControl)TableControlDetailDialogSWTRenderer.this.getVElement(), TableControlDetailDialogSWTRenderer.this.getView()));
            return dialog;
        }
    }
}

