/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecp.common.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.DefaultReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.context.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.context.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.Activator;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.MasterDetailAction;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.ecp.CreateChildAction;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.osgi.framework.FrameworkUtil;

public class TreeMasterDetailSWTRenderer
extends AbstractSWTRenderer<VTreeMasterDetail> {
    public static final String DETAIL_KEY = "detail";
    public static final String ROOT_KEY = "root";
    private SWTGridDescription rendererGridDescription;
    private Font detailsFont;
    private Color titleColor;
    private Font titleFont;
    private Color headerBgColor;
    private TreeViewer treeViewer;
    public static final String GLOBAL_ADDITIONS = "global_additions";
    private ScrolledComposite rightPanel;
    private Composite container;
    private Composite rightPanelContainerComposite;

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite form = this.createMasterDetailForm(parent);
        this.createHeader(form);
        SashForm sash = this.createSash(form);
        Composite masterPanel = this.createMasterPanel(sash);
        this.createRightPanelContent((Composite)sash);
        sash.setWeights(new int[]{1, 3});
        this.createMasterTree(masterPanel);
        form.layout(true);
        return form;
    }

    protected SashForm createSash(Composite parent) {
        Composite sashComposite = new Composite(parent, 4);
        GridLayout sashLayout = GridLayoutFactory.fillDefaults().create();
        sashLayout.marginWidth = 5;
        sashComposite.setLayout((Layout)sashLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)sashComposite);
        SashForm sash = new SashForm(sashComposite, 256);
        sash.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)sash);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sash);
        sash.setSashWidth(5);
        return sash;
    }

    protected Composite createMasterDetailForm(Composite parent) {
        Composite form = new Composite(parent, 2048);
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        form.setLayout((Layout)layout);
        form.setBackgroundMode(2);
        return form;
    }

    protected TreeViewer createMasterTree(Composite masterPanel) {
        EObject modelElement = this.getViewModelContext().getDomainModel();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelElement);
        final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        final AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                return new Object[]{((RootObject)object).getRoot()};
            }
        };
        final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.treeViewer = new TreeViewer(masterPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(100, -1).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider(adapterFactoryLabelProvider));
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)new RootObject(modelElement));
        this.addDragAndDropSupport(modelElement, this.treeViewer, editingDomain);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeMasterViewSelectionListener());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)modelElement));
        this.fillContextMenu(this.treeViewer, editingDomain);
        this.treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                adapterFactoryContentProvider.dispose();
                adapterFactoryLabelProvider.dispose();
                adapterFactory.dispose();
                if (TreeMasterDetailSWTRenderer.this.titleFont != null) {
                    TreeMasterDetailSWTRenderer.this.titleFont.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.detailsFont != null) {
                    TreeMasterDetailSWTRenderer.this.detailsFont.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.titleColor != null) {
                    TreeMasterDetailSWTRenderer.this.titleColor.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.headerBgColor != null) {
                    TreeMasterDetailSWTRenderer.this.headerBgColor.dispose();
                }
            }
        });
        return this.treeViewer;
    }

    protected ILabelProvider getLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        return adapterFactoryLabelProvider;
    }

    protected Composite createMasterPanel(SashForm sash) {
        Composite leftPanel = new Composite((Composite)sash, 0);
        leftPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)leftPanel);
        leftPanel.setBackgroundMode(2);
        return leftPanel;
    }

    protected void createHeader(Composite parent) {
        Composite headerComposite = new Composite(parent, 0);
        GridLayout headerLayout = GridLayoutFactory.fillDefaults().create();
        headerComposite.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)headerComposite);
        this.headerBgColor = new Color((Device)parent.getDisplay(), new RGB(220, 240, 247));
        headerComposite.setBackground(this.headerBgColor);
        EObject modelElement = this.getViewModelContext().getDomainModel();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelElement);
        if (modelElement.eContainer() == null && !DynamicEObjectImpl.class.isInstance(modelElement)) {
            Composite header = this.getPageHeader(headerComposite);
            List<Action> actions = this.readToolbarActions(modelElement, editingDomain);
            ToolBar toolBar = new ToolBar(header, 0x820000);
            FormData formData = new FormData();
            formData.right = new FormAttachment(100, 0);
            toolBar.setLayoutData((Object)formData);
            toolBar.layout();
            ToolBarManager toolBarManager = new ToolBarManager(toolBar);
            for (Action action : actions) {
                toolBarManager.add((IAction)action);
            }
            toolBarManager.update(true);
            header.layout();
        }
    }

    private Composite getPageHeader(Composite parent) {
        Composite header = new Composite(parent, 4);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        header.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)header);
        header.setBackground(parent.getBackground());
        Label titleImage = new Label(header, 4);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/view.png"));
        titleImage.setImage(new Image((Device)parent.getDisplay(), imageDescriptor.getImageData()));
        FormData titleImageData = new FormData();
        int imageOffset = -titleImage.computeSize((int)-1, (int)-1).y / 2;
        titleImageData.top = new FormAttachment(50, imageOffset);
        titleImageData.left = new FormAttachment(0, 10);
        titleImage.setLayoutData((Object)titleImageData);
        Label title = new Label(header, 64);
        title.setText("View Editor");
        this.titleFont = new Font((Device)title.getDisplay(), this.getDefaultFontName((Control)title), 12, 1);
        title.setFont(this.titleFont);
        title.setForeground(this.getTitleColor(parent));
        FormData titleData = new FormData();
        title.setLayoutData((Object)titleData);
        titleData.left = new FormAttachment((Control)titleImage, 5, -1);
        return header;
    }

    private Color getTitleColor(Composite parent) {
        if (this.titleColor == null) {
            this.titleColor = new Color((Device)parent.getDisplay(), new RGB(25, 76, 127));
        }
        return this.titleColor;
    }

    protected ScrolledComposite createRightPanelContent(Composite parent) {
        this.rightPanel = new ScrolledComposite(parent, 768);
        this.rightPanel.setShowFocusedControl(true);
        this.rightPanel.setExpandVertical(true);
        this.rightPanel.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.rightPanel);
        this.rightPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.rightPanel.setBackground(parent.getDisplay().getSystemColor(1));
        this.container = new Composite((Composite)this.rightPanel, 4);
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.container);
        this.container.setBackground(this.rightPanel.getBackground());
        Composite header = new Composite(this.container, 4);
        GridLayout headerLayout = GridLayoutFactory.fillDefaults().create();
        headerLayout.marginWidth = 5;
        header.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)header);
        header.setBackground(this.rightPanel.getBackground());
        Label label = new Label(header, 64);
        label.setText("Details");
        this.detailsFont = new Font((Device)label.getDisplay(), this.getDefaultFontName((Control)label), 10, 1);
        label.setFont(this.detailsFont);
        label.setForeground(this.getTitleColor(parent));
        label.setBackground(header.getBackground());
        this.rightPanelContainerComposite = new Composite(this.container, 4);
        this.rightPanelContainerComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.rightPanelContainerComposite);
        this.rightPanelContainerComposite.setBackground(this.rightPanel.getBackground());
        this.rightPanel.setContent((Control)this.container);
        this.rightPanel.layout();
        this.container.layout();
        Point point = this.container.computeSize(-1, -1);
        this.rightPanel.setMinSize(point);
        return this.rightPanel;
    }

    private String getDefaultFontName(Control control) {
        return control.getDisplay().getSystemFont().getFontData()[0].getName();
    }

    private List<Action> readToolbarActions(EObject modelElement, EditingDomain editingDomain) {
        IConfigurationElement[] controls;
        ArrayList<Action> actions = new ArrayList<Action>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return actions;
        }
        if (!VView.class.isInstance(modelElement)) {
            return actions;
        }
        final VView view = (VView)modelElement;
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.masterDetailActions");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String location = e.getAttribute("location");
                if (location.equals("toolbar")) {
                    String label = e.getAttribute("label");
                    String imagePath = e.getAttribute("imagePath");
                    final MasterDetailAction command = (MasterDetailAction)((Object)e.createExecutableExtension("command"));
                    Action newAction = new Action(){

                        public void run() {
                            super.run();
                            command.execute((EObject)view);
                        }
                    };
                    newAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)command)).getClass()).getResource(imagePath)));
                    newAction.setText(label);
                    actions.add(newAction);
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            ++n2;
        }
        return actions;
    }

    private void addDragAndDropSupport(EObject modelElement, TreeViewer treeViewer, EditingDomain editingDomain) {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        treeViewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)treeViewer));
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter(editingDomain, (Viewer)treeViewer);
        treeViewer.addDropSupport(7, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
    }

    private void fillContextMenu(final TreeViewer treeViewer, final EditingDomain editingDomain) {
        final ChildrenDescriptorCollector childrenDescriptorCollector = new ChildrenDescriptorCollector();
        final List<MasterDetailAction> menuActions = this.readMasterDetailActions();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (treeViewer.getSelection().isEmpty()) {
                    return;
                }
                EObject root = ((RootObject)treeViewer.getInput()).getRoot();
                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                    if (selection.size() == 1) {
                        EObject eObject = (EObject)selection.getFirstElement();
                        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
                        if (domain == null) {
                            return;
                        }
                        Collection descriptors = childrenDescriptorCollector.getDescriptors(eObject);
                        TreeMasterDetailSWTRenderer.this.fillContextMenu(manager, descriptors, editingDomain, eObject);
                    }
                    if (!selection.toList().contains(root)) {
                        manager.add((IContributionItem)new Separator(TreeMasterDetailSWTRenderer.GLOBAL_ADDITIONS));
                        TreeMasterDetailSWTRenderer.this.addDeleteActionToContextMenu(editingDomain, manager, selection);
                    }
                    manager.add((IContributionItem)new Separator());
                    if (selection.getFirstElement() != null && EObject.class.isInstance(selection.getFirstElement())) {
                        final EObject selectedObject = (EObject)selection.getFirstElement();
                        for (final MasterDetailAction menuAction : menuActions) {
                            if (!menuAction.shouldShow(selectedObject)) continue;
                            Action newAction = new Action(){

                                public void run() {
                                    super.run();
                                    menuAction.execute(selectedObject);
                                }
                            };
                            newAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)menuAction)).getClass()).getResource(menuAction.getImagePath())));
                            newAction.setText(menuAction.getLabel());
                            manager.add((IAction)newAction);
                        }
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
    }

    protected List<MasterDetailAction> readMasterDetailActions() {
        IConfigurationElement[] controls;
        ArrayList<MasterDetailAction> commands = new ArrayList<MasterDetailAction>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return commands;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.masterDetailActions");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String location = e.getAttribute("location");
                if (location.equals("menu")) {
                    String label = e.getAttribute("label");
                    String imagePath = e.getAttribute("imagePath");
                    MasterDetailAction command = (MasterDetailAction)((Object)e.createExecutableExtension("command"));
                    command.setLabel(label);
                    command.setImagePath(imagePath);
                    commands.add(command);
                }
            }
            catch (CoreException ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
            }
            ++n2;
        }
        return commands;
    }

    private void fillContextMenu(IMenuManager manager, Collection<?> descriptors, final EditingDomain domain, final EObject eObject) {
        for (Object descriptor : descriptors) {
            final CommandParameter cp = (CommandParameter)descriptor;
            if (!CommandParameter.class.isInstance(descriptor) || cp.getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            manager.add((IAction)new CreateChildAction(domain, (ISelection)new StructuredSelection((Object)eObject), descriptor){

                @Override
                public void run() {
                    super.run();
                    EReference reference = ((CommandParameter)this.descriptor).getEReference();
                    domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)eObject, (Object)reference, (Object)cp.getEValue()));
                }
            });
        }
    }

    private void addDeleteActionToContextMenu(final EditingDomain editingDomain, IMenuManager manager, final IStructuredSelection selection) {
        Action deleteAction = new Action(){

            public void run() {
                super.run();
                for (Object obj : selection.toList()) {
                    editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, obj));
                }
                TreeMasterDetailSWTRenderer.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)TreeMasterDetailSWTRenderer.this.getViewModelContext().getDomainModel()));
            }
        };
        deleteAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/delete.png")));
        deleteAction.setText("Delete");
        manager.add((IAction)deleteAction);
    }

    protected void manipulateViewContext(ViewModelContext viewContext) {
    }

    protected Composite getDetailContainer() {
        return this.rightPanelContainerComposite;
    }

    protected Object manipulateSelection(Object treeSelected) {
        return treeSelected;
    }

    protected void cleanCustomOnSelectionChange() {
    }

    protected void relayoutDetail() {
        this.rightPanelContainerComposite.layout();
        Point point = this.container.computeSize(-1, -1);
        this.rightPanel.setMinSize(point);
    }

    private class RootObject {
        private final EObject modelElement;

        public RootObject(EObject modelElement) {
            this.modelElement = modelElement;
        }

        public EObject getRoot() {
            return this.modelElement;
        }
    }

    private class TreeMasterViewSelectionListener
    implements ISelectionChangedListener {
        private Composite childComposite;
        private ReferenceService referenceService;

        public TreeMasterViewSelectionListener() {
            this.referenceService = TreeMasterDetailSWTRenderer.this.getViewModelContext().hasService(ReferenceService.class) ? (ReferenceService)TreeMasterDetailSWTRenderer.this.getViewModelContext().getService(ReferenceService.class) : new DefaultReferenceService();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object treeSelected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            Object selected = TreeMasterDetailSWTRenderer.this.manipulateSelection(treeSelected);
            if (selected instanceof EObject) {
                try {
                    if (this.childComposite != null) {
                        this.childComposite.dispose();
                        TreeMasterDetailSWTRenderer.this.cleanCustomOnSelectionChange();
                    }
                    this.childComposite = this.createComposite();
                    Object root = TreeMasterDetailSWTRenderer.this.manipulateSelection(((RootObject)((TreeViewer)event.getSource()).getInput()).getRoot());
                    LinkedHashMap<String, Boolean> context = new LinkedHashMap<String, Boolean>();
                    context.put(TreeMasterDetailSWTRenderer.DETAIL_KEY, true);
                    if (selected.equals(root)) {
                        context.put(TreeMasterDetailSWTRenderer.ROOT_KEY, true);
                        VView vView = ((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).getDetailView();
                        if (vView.getChildren().isEmpty()) {
                            vView = ViewProviderHelper.getView((EObject)((EObject)selected), context);
                        }
                        if (DynamicEObjectImpl.class.isInstance(selected)) {
                            ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)vView, (EObject)selected, new ViewModelService[]{this.referenceService});
                            TreeMasterDetailSWTRenderer.this.manipulateViewContext(viewContext);
                            ECPSWTViewRenderer.INSTANCE.render(this.childComposite, viewContext);
                        } else {
                            ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)vView, (EObject)selected, new ViewModelService[]{this.referenceService});
                            TreeMasterDetailSWTRenderer.this.manipulateViewContext(viewContext);
                            ECPSWTViewRenderer.INSTANCE.render(this.childComposite, viewContext);
                        }
                    } else {
                        VView view = ViewProviderHelper.getView((EObject)((EObject)selected), context);
                        ViewModelContext viewContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, (EObject)selected, new ViewModelService[]{this.referenceService});
                        TreeMasterDetailSWTRenderer.this.manipulateViewContext(viewContext);
                        ECPSWTViewRenderer.INSTANCE.render(this.childComposite, viewContext);
                    }
                    TreeMasterDetailSWTRenderer.this.relayoutDetail();
                }
                catch (ECPRendererException e) {
                    Activator.getDefault().getReportService().report((AbstractReport)new StatusReport(new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e)));
                }
            }
        }

        private Composite createComposite() {
            Composite parent = TreeMasterDetailSWTRenderer.this.getDetailContainer();
            Composite composite = new Composite(parent, 0);
            composite.setBackground(parent.getBackground());
            GridLayout gridLayout = GridLayoutFactory.fillDefaults().create();
            composite.setLayout((Layout)gridLayout);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
            composite.layout(true, true);
            return composite;
        }
    }
}

