/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public final class ExportProjectHelper {
    private static final String FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*" + FILE_EXTENSION + ")"};
    public static final String[] FILTER_EXTS = new String[]{"*" + FILE_EXTENSION};
    private static final String ECP_UI_PLUGIN_ID = "org.eclipse.emf.ecp.ui";
    private static final String FILE_DIALOG_HELPER_CLASS = "org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelperImpl";

    private ExportProjectHelper() {
    }

    public static void exportProject(InternalProject internalProject, Shell shell) {
        ESLocalProject localProject = EMFStoreProvider.INSTANCE.getProjectSpace(internalProject);
        String filePath = ExportProjectHelper.getFilePathByFileDialog(shell, internalProject.getName());
        if (filePath == null) {
            return;
        }
        try {
            new ExportImportControllerExecutor(new File(filePath), (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectSpaceController((ProjectSpace)((ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI())));
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
    }

    private static String getFilePathByFileDialog(Shell shell, String modelElementName) {
        try {
            Class clazz = ExportProjectHelper.loadClass(ECP_UI_PLUGIN_ID, FILE_DIALOG_HELPER_CLASS);
            ECPFileDialogHelper fileDialogHelper = (ECPFileDialogHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return fileDialogHelper.getPathForExport(shell, modelElementName);
        }
        catch (ClassNotFoundException ex) {
            Activator.log(ex);
        }
        catch (InstantiationException ex) {
            Activator.log(ex);
        }
        catch (IllegalAccessException ex) {
            Activator.log(ex);
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        catch (InvocationTargetException ex) {
            Activator.log(ex);
        }
        catch (NoSuchMethodException ex) {
            Activator.log(ex);
        }
        catch (SecurityException ex) {
            Activator.log(ex);
        }
        return null;
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + " cannot be loaded because bundle " + bundleName + " cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }
}

