/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.migrator;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.osgi.framework.Bundle;

public final class ViewModelMigratorUtil {
    private static final String MIGRATOR_EXTENSION = "org.eclipse.emf.ecp.view.migrator.migrators";
    private static final String MIGRATOR_CLASS = "class";
    private static final String MIGRATOR_PRIORITY = "priority";

    private ViewModelMigratorUtil() {
    }

    public static ViewModelMigrator getViewModelMigrator() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MIGRATOR_EXTENSION);
        int topPriority = 0;
        Class topClass = null;
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    int priority = Integer.parseInt(configurationElement.getAttribute(MIGRATOR_PRIORITY));
                    if (priority > topPriority) {
                        Class migratorClass;
                        topClass = migratorClass = ViewModelMigratorUtil.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute(MIGRATOR_CLASS));
                        topPriority = priority;
                    }
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidRegistryObjectException ex) {
                    ex.printStackTrace();
                }
                ++n4;
            }
            ++n2;
        }
        if (topClass != null) {
            try {
                return (ViewModelMigrator)topClass.newInstance();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }
}

