/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.section.model.VSectionPackage;
import org.eclipse.emf.ecp.view.spi.section.model.VSectionedArea;
import org.eclipse.emf.ecp.view.spi.section.swt.AbstractSectionSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SectionNodeSWTRenderer
extends AbstractSectionSWTRenderer {
    private Set<AbstractSectionSWTRenderer> childRenderers;
    private SWTGridDescription rendererGridDescription;
    private ModelChangeListener listener;
    private ExpandableComposite expandableComposite;

    protected void preInit() {
        super.preInit();
        this.listener = new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch()) {
                    return;
                }
                if (notification.getNotifier() != SectionNodeSWTRenderer.this.getVElement()) {
                    return;
                }
                if (notification.getStructuralFeature() == VSectionPackage.eINSTANCE.getSection_Collapsed()) {
                    for (AbstractSectionSWTRenderer childRenderer : SectionNodeSWTRenderer.this.childRenderers) {
                        childRenderer.adjustLayoutData(!((VSection)SectionNodeSWTRenderer.this.getVElement()).isCollapsed());
                    }
                    ((Control)SectionNodeSWTRenderer.this.getControls().values().iterator().next()).getParent().layout(false);
                }
            }
        };
        this.getViewModelContext().registerViewChangeListener(this.listener);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        this.childRenderers = new LinkedHashSet<AbstractSectionSWTRenderer>();
        this.rendererGridDescription = new SWTGridDescription();
        this.rendererGridDescription.setColumns(4);
        ArrayList<SWTGridCell> gridCells = new ArrayList<SWTGridCell>();
        gridCells.add(this.createGridCell(0, 0, this));
        gridCells.add(this.createGridCell(0, 1, this));
        gridCells.add(this.createGridCell(0, 2, this));
        gridCells.add(this.createGridCell(0, 3, this));
        int row = 1;
        for (VSection item : ((VSection)this.getVElement()).getChildItems()) {
            AbstractSWTRenderer itemRenderer = this.getSWTRendererFactory().getRenderer((VElement)item, this.getViewModelContext());
            SWTGridDescription itemGridDescription = itemRenderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            this.childRenderers.add((AbstractSectionSWTRenderer)itemRenderer);
            int itemRows = itemGridDescription.getRows();
            for (SWTGridCell itemCell : itemGridDescription.getGrid()) {
                gridCells.add(this.createGridCell(itemCell.getRow() + row, itemCell.getColumn(), (AbstractSWTRenderer<? extends VElement>)((AbstractSWTRenderer)itemCell.getRenderer())));
            }
            row += itemRows;
        }
        this.rendererGridDescription.setGrid(gridCells);
        return this.rendererGridDescription;
    }

    private SWTGridCell createGridCell(int row, int column, AbstractSWTRenderer<? extends VElement> renderer) {
        SWTGridCell gridCell = new SWTGridCell(row, column, renderer);
        gridCell.setVerticalFill(false);
        gridCell.setVerticalGrab(false);
        if (column == 3) {
            gridCell.setHorizontalGrab(true);
        } else {
            gridCell.setHorizontalGrab(false);
        }
        return gridCell;
    }

    @Override
    protected Control createFirstColumn(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(this.computeLeftMargin(), 0, 0, 0).applyTo(composite);
        this.expandableComposite = new ExpandableComposite(composite, 0, 2);
        this.expandableComposite.setExpanded(!((VSection)this.getVElement()).isCollapsed());
        String text = ((VSection)this.getVElement()).getName() == null ? "" : ((VSection)this.getVElement()).getName();
        this.expandableComposite.setText(text);
        this.initExpandableComposite(this.expandableComposite);
        return composite;
    }

    private void initExpandableComposite(ExpandableComposite expandableComposite) {
        expandableComposite.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                ((VSection)SectionNodeSWTRenderer.this.getVElement()).setCollapsed(!e.getState());
            }
        });
    }

    private int computeLeftMargin() {
        int numberOfParents = 0;
        EObject current = ((VSection)this.getVElement()).eContainer();
        while (!VSectionedArea.class.isInstance(current)) {
            ++numberOfParents;
            current = current.eContainer();
        }
        return (numberOfParents + 1) * 8;
    }

    @Override
    protected void adjustLayoutData(boolean vis) {
        super.adjustLayoutData(vis);
        for (AbstractSectionSWTRenderer childRenderer : this.childRenderers) {
            boolean visible = vis;
            if (((VSection)this.getVElement()).isCollapsed()) {
                visible = false;
            }
            childRenderer.adjustLayoutData(visible);
        }
    }

    protected void applyEnable() {
        this.expandableComposite.setEnabled(((VSection)this.getVElement()).isEnabled());
    }

    protected void dispose() {
        this.getViewModelContext().unregisterViewChangeListener(this.listener);
        super.dispose();
    }
}

