/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GenerateTableColumnsHandler
extends MasterDetailAction {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selection = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (selection == null || !(selection instanceof EObject)) {
            return null;
        }
        this.execute((EObject)selection);
        return null;
    }

    public boolean shouldShow(EObject eObject) {
        return VTableControl.class.isInstance(eObject);
    }

    public void execute(EObject object) {
        VTableControl tableControl = (VTableControl)VTableControl.class.cast(object);
        VDomainModelReference domainModelReference = tableControl.getDomainModelReference();
        if (domainModelReference == null || !VTableDomainModelReference.class.isInstance(domainModelReference)) {
            return;
        }
        VTableDomainModelReference tableDMR = (VTableDomainModelReference)domainModelReference;
        Iterator structuralFeatureIterator = tableDMR.getEStructuralFeatureIterator();
        if (structuralFeatureIterator == null || !structuralFeatureIterator.hasNext()) {
            return;
        }
        EStructuralFeature eStructuralFeature = (EStructuralFeature)structuralFeatureIterator.next();
        if (!EReference.class.isInstance(eStructuralFeature)) {
            return;
        }
        EReference eReference = (EReference)eStructuralFeature;
        LinkedHashSet<EStructuralFeature> generatedFeatures = new LinkedHashSet<EStructuralFeature>();
        for (VDomainModelReference ref : tableDMR.getColumnDomainModelReferences()) {
            VFeaturePathDomainModelReference featureDMR = (VFeaturePathDomainModelReference)ref;
            generatedFeatures.add(featureDMR.getDomainModelEFeature());
        }
        LinkedHashSet<VFeaturePathDomainModelReference> references = new LinkedHashSet<VFeaturePathDomainModelReference>();
        for (EAttribute attribute : eReference.getEReferenceType().getEAllAttributes()) {
            if (generatedFeatures.contains(attribute)) continue;
            VFeaturePathDomainModelReference dmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            dmr.setDomainModelEFeature((EStructuralFeature)attribute);
            references.add(dmr);
        }
        EditingDomain editingDomainFor = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
        Command command = AddCommand.create((EditingDomain)editingDomainFor, (Object)tableDMR, (Object)VTablePackage.eINSTANCE.getTableDomainModelReference_ColumnDomainModelReferences(), references);
        editingDomainFor.getCommandStack().execute(command);
    }
}

