/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.table.internal.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;

public class TableValidationInitiator
implements GlobalViewModelService {
    private final Map<UniqueSetting, TableContextMapping> mapping = new LinkedHashMap<UniqueSetting, TableContextMapping>();

    public void instantiate(ViewModelContext context) {
        context.registerDomainChangeListener(new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch() || TableValidationInitiator.this.mapping.isEmpty()) {
                    return;
                }
                TableContextMapping tableContextMapping = (TableContextMapping)TableValidationInitiator.this.mapping.get(UniqueSetting.createSetting((EObject)notification.getNotifier(), (EStructuralFeature)notification.getStructuralFeature()));
                if (tableContextMapping == null) {
                    return;
                }
                for (EObject newValue : notification.getNewEObjects()) {
                    tableContextMapping.context.getChildContext(newValue, (VElement)tableContextMapping.control, TableValidationInitiator.this.getView(tableContextMapping.control), new ViewModelService[0]);
                }
            }
        });
        this.checkForTables(context);
    }

    private void checkForTables(ViewModelContext context) {
        VElement viewRoot = context.getViewModel();
        TreeIterator eAllContents = viewRoot.eAllContents();
        while (eAllContents.hasNext()) {
            VTableControl tableControl;
            EObject eObject = (EObject)eAllContents.next();
            if (!VTableControl.class.isInstance(eObject) || (tableControl = (VTableControl)VTableControl.class.cast(eObject)).getDetailEditing() != DetailEditing.WITH_PANEL) continue;
            Iterator iterator = tableControl.getDomainModelReference().getIterator();
            EStructuralFeature.Setting tableSetting = (EStructuralFeature.Setting)iterator.next();
            this.mapping.put(UniqueSetting.createSetting((EStructuralFeature.Setting)tableSetting), new TableContextMapping(tableControl, context));
            EList tableContents = (EList)tableSetting.get(true);
            for (EObject tableEObject : tableContents) {
                VView detailView = this.getView(tableControl);
                ViewModelContext childContext = context.getChildContext(tableEObject, (VElement)tableControl, detailView, new ViewModelService[0]);
                childContext.addContextUser((Object)this);
            }
        }
    }

    private VView getView(VTableControl tableControl) {
        VView detailView = tableControl.getDetailView();
        if (detailView == null) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)tableControl.getDomainModelReference().getIterator().next();
            EReference reference = (EReference)setting.getEStructuralFeature();
            detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), Collections.emptyMap());
        }
        return (VView)EcoreUtil.copy((EObject)detailView);
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
        this.checkForTables(childContext);
    }

    private static class TableContextMapping {
        private final VTableControl control;
        private final ViewModelContext context;

        public TableContextMapping(VTableControl control, ViewModelContext context) {
            this.control = control;
            this.context = context;
        }
    }
}

