/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.util;

import java.io.File;
import org.eclipse.emf.ecp.internal.ui.PreferenceHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPExportHandlerHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPImportHandlerHelper;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ECPFileDialogHelperImpl
implements ECPFileDialogHelper {
    private static final String IMPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.importModelPath";
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.exportModelPath";
    private static final String FILE_EXTENSION = "xmi";

    public String getPathForImport(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterNames(ECPImportHandlerHelper.FILTER_NAMES);
        dialog.setFilterExtensions(ECPImportHandlerHelper.FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)IMPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        PreferenceHelper.setPreference((String)IMPORT_MODEL_PATH, (String)file.getParent());
        return file.getAbsolutePath();
    }

    public String getPathForExport(Shell shell, String fileName) {
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setFilterNames(ECPExportHandlerHelper.FILTER_NAMES);
        dialog.setFilterExtensions(ECPExportHandlerHelper.FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)EXPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        dialog.setOverwrite(true);
        try {
            String initialFileName = "ModelElement_" + fileName + "." + FILE_EXTENSION;
            dialog.setFileName(initialFileName);
        }
        catch (NullPointerException nullPointerException) {}
        String filePath = dialog.open();
        return filePath;
    }
}

