/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.context;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.context.internal.reporting.ViewModelServiceNotAvailableReport;
import org.eclipse.emf.ecp.view.internal.context.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

public class ViewModelContextImpl
implements ViewModelContext {
    private static final String MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL = "ModelChangeAddRemoveListener must not be null.";
    private static final String THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED = "The ViewModelContext was already disposed.";
    private final VElement view;
    private final EObject domainObject;
    private final List<ModelChangeListener> viewModelChangeListener = new CopyOnWriteArrayList<ModelChangeListener>();
    private final List<ModelChangeListener> domainModelChangeListener = new ArrayList<ModelChangeListener>();
    private EContentAdapter domainModelContentAdapter;
    private EContentAdapter viewModelContentAdapter;
    private final SortedSet<ViewModelService> viewServices = new TreeSet<ViewModelService>(new Comparator<ViewModelService>(){

        @Override
        public int compare(ViewModelService arg0, ViewModelService arg1) {
            if (arg0.getPriority() == arg1.getPriority()) {
                return arg0.getClass().getName().compareTo(arg1.getClass().getName());
            }
            return arg0.getPriority() - arg1.getPriority();
        }
    });
    private boolean isDisposed;
    private final Map<String, Object> keyObjectMap = new LinkedHashMap<String, Object>();
    private boolean isDisposing;
    private final Map<UniqueSetting, Set<VControl>> settingToControlMap = new LinkedHashMap<UniqueSetting, Set<VControl>>();
    private final Map<VControl, DomainModelReferenceChangeListener> controlChangeListener = new LinkedHashMap<VControl, DomainModelReferenceChangeListener>();
    private Resource resource;
    private final Set<Object> users = new LinkedHashSet<Object>();

    public ViewModelContextImpl(VElement view, EObject domainObject) {
        this.view = view;
        this.domainObject = domainObject;
        this.instantiate();
    }

    public ViewModelContextImpl(VElement view, EObject domainObject, ViewModelService ... modelServices) {
        this.view = view;
        this.domainObject = domainObject;
        ViewModelService[] viewModelServiceArray = modelServices;
        int n = modelServices.length;
        int n2 = 0;
        while (n2 < n) {
            ViewModelService vms = viewModelServiceArray[n2];
            this.viewServices.add(vms);
            ++n2;
        }
        this.instantiate();
    }

    private void instantiate() {
        this.addResourceIfNecessary();
        ViewModelUtil.resolveDomainReferences((EObject)this.getViewModel(), (EObject)this.getDomainModel());
        this.viewModelContentAdapter = new ViewModelContentAdapter();
        this.view.eAdapters().add((Object)this.viewModelContentAdapter);
        this.domainModelContentAdapter = new DomainModelContentAdapter();
        this.domainObject.eAdapters().add((Object)this.domainModelContentAdapter);
        this.createSettingToControlMapping();
        this.readAbstractViewServices();
        for (ViewModelService viewService : this.viewServices) {
            viewService.instantiate(this);
        }
    }

    private void addResourceIfNecessary() {
        if (this.domainObject.eResource() != null) {
            return;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack(), (ResourceSet)rs);
        rs.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        this.resource = rs.createResource(URI.createURI((String)"VIRTAUAL_URI"));
        if (this.resource != null) {
            this.resource.getContents().add((Object)this.domainObject);
        }
    }

    private void createSettingToControlMapping() {
        this.checkAndUpdateSettingToControlMapping((EObject)this.view);
        TreeIterator eAllContents = this.view.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            this.checkAndUpdateSettingToControlMapping(eObject);
        }
    }

    private void checkAndUpdateSettingToControlMapping(EObject eObject) {
        if (VControl.class.isInstance(eObject)) {
            final VControl vControl = (VControl)eObject;
            if (vControl.getDomainModelReference() == null) {
                return;
            }
            this.updateControlMapping(vControl);
            DomainModelReferenceChangeListener changeListener = new DomainModelReferenceChangeListener(){

                public void notifyChange() {
                    ViewModelContextImpl.this.updateControlMapping(vControl);
                }
            };
            this.controlChangeListener.put(vControl, changeListener);
            vControl.getDomainModelReference().getChangeListener().add((Object)changeListener);
            this.registerDomainChangeListener((ModelChangeListener)vControl.getDomainModelReference());
        }
    }

    private void updateControlMapping(VControl vControl) {
        for (UniqueSetting setting : this.settingToControlMap.keySet()) {
            this.settingToControlMap.get(setting).remove(vControl);
        }
        Iterator iterator = vControl.getDomainModelReference().getIterator();
        while (iterator.hasNext()) {
            EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator.next();
            if (setting == null) continue;
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)setting);
            if (!this.settingToControlMap.containsKey(uniqueSetting)) {
                this.settingToControlMap.put(uniqueSetting, new LinkedHashSet());
            }
            this.settingToControlMap.get(uniqueSetting).add(vControl);
        }
    }

    private void vControlRemoved(VControl vControl) {
        if (vControl.getDomainModelReference() == null) {
            return;
        }
        Iterator iterator = vControl.getDomainModelReference().getIterator();
        while (iterator.hasNext()) {
            EStructuralFeature.Setting next = (EStructuralFeature.Setting)iterator.next();
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)next);
            if (!this.settingToControlMap.containsKey(uniqueSetting)) continue;
            this.settingToControlMap.get(uniqueSetting).remove(vControl);
            if (this.settingToControlMap.get(uniqueSetting).size() != 0) continue;
            this.settingToControlMap.remove(uniqueSetting);
        }
        vControl.getDomainModelReference().getChangeListener().remove((Object)this.controlChangeListener.get(vControl));
        this.controlChangeListener.remove(vControl);
        this.unregisterDomainChangeListener((ModelChangeListener)vControl.getDomainModelReference());
    }

    private void vControlAdded(VControl vControl) {
        if (vControl.getDomainModelReference() == null) {
            return;
        }
        Iterator iterator = vControl.getDomainModelReference().getIterator();
        while (iterator.hasNext()) {
            EStructuralFeature.Setting next = (EStructuralFeature.Setting)iterator.next();
            if (next == null) continue;
            UniqueSetting uniqueSetting = UniqueSetting.createSetting((EStructuralFeature.Setting)next);
            if (!this.settingToControlMap.containsKey(uniqueSetting)) {
                this.settingToControlMap.put(uniqueSetting, new LinkedHashSet());
            }
            this.settingToControlMap.get(uniqueSetting).add(vControl);
        }
    }

    @Override
    public Set<VControl> getControlsFor(EStructuralFeature.Setting setting) {
        return this.settingToControlMap.get(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
    }

    @Override
    public Set<VControl> getControlsFor(UniqueSetting setting) {
        return this.settingToControlMap.get(setting);
    }

    private void readAbstractViewServices() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.context.viewServices");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                ViewModelService viewService = (ViewModelService)e.createExecutableExtension("class");
                this.viewServices.add(viewService);
            }
            catch (CoreException e1) {
                Activator.log(e1);
            }
            ++n2;
        }
    }

    @Override
    public VElement getViewModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.view;
    }

    @Override
    public EObject getDomainModel() {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        return this.domainObject;
    }

    @Override
    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposing = true;
        if (this.resource != null) {
            this.resource.getContents().remove((Object)this.domainObject);
        }
        this.view.eAdapters().remove((Object)this.viewModelContentAdapter);
        this.domainObject.eAdapters().remove((Object)this.domainModelContentAdapter);
        this.viewModelChangeListener.clear();
        this.domainModelChangeListener.clear();
        for (ViewModelService viewService : this.viewServices) {
            viewService.dispose();
        }
        this.viewServices.clear();
        this.settingToControlMap.clear();
        for (VControl vControl : this.controlChangeListener.keySet()) {
            if (vControl.getDomainModelReference() != null) {
                vControl.getDomainModelReference().getChangeListener().remove((Object)this.controlChangeListener.get(vControl));
            }
            this.unregisterDomainChangeListener((ModelChangeListener)vControl.getDomainModelReference());
        }
        this.controlChangeListener.clear();
        this.isDisposing = false;
        this.isDisposed = true;
    }

    @Override
    public void registerViewChangeListener(ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.viewModelChangeListener.add(modelChangeListener);
    }

    @Override
    public void unregisterViewChangeListener(ModelChangeListener modelChangeListener) {
        this.viewModelChangeListener.remove(modelChangeListener);
    }

    @Override
    public void registerDomainChangeListener(ModelChangeListener modelChangeListener) {
        if (this.isDisposed) {
            throw new IllegalStateException(THE_VIEW_MODEL_CONTEXT_WAS_ALREADY_DISPOSED);
        }
        if (modelChangeListener == null) {
            throw new IllegalArgumentException(MODEL_CHANGE_LISTENER_MUST_NOT_BE_NULL);
        }
        this.domainModelChangeListener.add(modelChangeListener);
    }

    @Override
    public void unregisterDomainChangeListener(ModelChangeListener modelChangeListener) {
        this.domainModelChangeListener.remove(modelChangeListener);
    }

    @Override
    public <T> boolean hasService(Class<T> serviceType) {
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        for (ViewModelService service : this.viewServices) {
            if (!serviceType.isInstance(service)) continue;
            return (T)service;
        }
        Activator.getInstance().getReportService().report(new ViewModelServiceNotAvailableReport(serviceType));
        return null;
    }

    public void addContextUser(Object user) {
        this.users.add(user);
    }

    public void removeContextUser(Object user) {
        this.users.remove(user);
        if (this.users.isEmpty()) {
            this.dispose();
        }
    }

    @Override
    public Object getContextValue(String key) {
        return this.keyObjectMap.get(key);
    }

    @Override
    public void putContextValue(String key, Object value) {
        this.keyObjectMap.put(key, value);
    }

    private class DomainModelContentAdapter
    extends EContentAdapter {
        private DomainModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyAdd(notifier);
            }
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.domainModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyRemove(notifier);
            }
        }
    }

    private class ViewModelContentAdapter
    extends EContentAdapter {
        private ViewModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (ViewModelContextImpl.this.isDisposed) {
                return;
            }
            if (notification.isTouch()) {
                return;
            }
            if (notification.getEventType() == 3 && VControl.class.isInstance(notification.getNewValue())) {
                ViewModelContextImpl.this.checkAndUpdateSettingToControlMapping((EObject)VControl.class.cast(notification.getNewValue()));
            }
            ModelChangeNotification modelChangeNotification = new ModelChangeNotification(notification);
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                modelChangeListener.notifyChange(modelChangeNotification);
            }
        }

        protected void addAdapter(Notifier notifier) {
            VControl control;
            super.addAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing || ViewModelContextImpl.this.isDisposed) {
                return;
            }
            if (VElement.class.isInstance(notifier)) {
                ViewModelUtil.resolveDomainReferences((EObject)((VElement)notifier), (EObject)ViewModelContextImpl.this.getDomainModel());
            }
            if (VControl.class.isInstance(notifier)) {
                ViewModelContextImpl.this.vControlAdded((VControl)notifier);
            }
            if (VDomainModelReference.class.isInstance(notifier) && (control = this.findControl((VDomainModelReference)VDomainModelReference.class.cast(notifier))) != null) {
                ViewModelContextImpl.this.updateControlMapping(control);
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyAdd(notifier);
            }
        }

        private VControl findControl(VDomainModelReference dmr) {
            EObject parent = dmr.eContainer();
            while (!VControl.class.isInstance(parent) && parent != null) {
                parent = parent.eContainer();
            }
            return (VControl)parent;
        }

        protected void removeAdapter(Notifier notifier) {
            super.removeAdapter(notifier);
            if (ViewModelContextImpl.this.isDisposing) {
                return;
            }
            if (VElement.class.isInstance(notifier)) {
                ((VElement)VElement.class.cast(notifier)).setDiagnostic(null);
            }
            if (VControl.class.isInstance(notifier)) {
                ViewModelContextImpl.this.vControlRemoved((VControl)notifier);
            }
            for (ModelChangeListener modelChangeListener : ViewModelContextImpl.this.viewModelChangeListener) {
                if (!ModelChangeAddRemoveListener.class.isInstance(modelChangeListener)) continue;
                ((ModelChangeAddRemoveListener)ModelChangeAddRemoveListener.class.cast(modelChangeListener)).notifyRemove(notifier);
            }
        }
    }
}

