/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.CompositeFactory;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DefaultReferenceService
implements ReferenceService {
    private EditingDomain editingDomain;

    public void instantiate(ViewModelContext context) {
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)context.getDomainModel());
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void addNewModelElements(EObject eObject, EReference eReference) {
        Collection classes = EMFUtils.getSubClasses((EClass)eReference.getEReferenceType());
        EObject newMEInstance = null;
        if (classes.size() > 1) {
            SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
            newMEInstance = SelectModelElementWizardFactory.openCreateNewModelElementDialog((SelectionComposite)helper);
        } else {
            newMEInstance = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        if (newMEInstance == null) {
            return;
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        if (!eReference.isContainment()) {
            this.addElementToModel(newMEInstance, eObject);
        }
        ECPControlHelper.addModelElementInReference((EObject)eObject, (EObject)newMEInstance, (EReference)eReference, (EditingDomain)this.editingDomain);
        this.openInNewContext(newMEInstance);
    }

    private void addElementToModel(EObject newElement, EObject eObject) {
        for (EReference ref : eObject.eClass().getEAllContainments()) {
            if (!ref.getEType().isInstance((Object)newElement)) continue;
            ECPControlHelper.addModelElementInReference((EObject)eObject, (EObject)newElement, (EReference)ref, (EditingDomain)this.editingDomain);
            return;
        }
        if (eObject.eContainer() != null) {
            this.addElementToModel(newElement, eObject.eContainer());
        } else {
            eObject.eResource().getContents().add((Object)newElement);
        }
    }

    public void openInNewContext(EObject eObject) {
        CustomDialog dialog = new CustomDialog(Display.getDefault().getActiveShell(), eObject);
        new ECPDialogExecutor(dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }

    public void addExistingModelElements(EObject eObject, EReference eReference) {
        Iterator allElements = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)eObject, (EClassifier)eReference.getEType()).iterator();
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        ECPControlHelper.removeExistingReferences((EObject)eObject, (EReference)eReference, elements);
        Set addedElements = SelectModelElementWizardFactory.openModelElementSelectionDialog(elements, (boolean)eReference.isMany());
        ECPControlHelper.addModelElementsInReference((EObject)eObject, (Set)addedElements, (EReference)eReference, (EditingDomain)this.editingDomain);
    }

    private class CustomDialog
    extends Dialog {
        private final EObject eObject;

        public CustomDialog(Shell activeShell, EObject eObject) {
            super(activeShell);
            this.eObject = eObject;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.eObject.eClass().getName());
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(450, 250).applyTo((Control)composite);
            ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            Composite content = new Composite((Composite)scrolledComposite, 0);
            GridLayoutFactory.fillDefaults().applyTo(content);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)content);
            ViewModelContext vmc = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)ViewProviderHelper.getView((EObject)this.eObject, null), this.eObject, new ViewModelService[]{new DefaultReferenceService()});
            try {
                ECPSWTViewRenderer.INSTANCE.render(content, vmc);
            }
            catch (ECPRendererException ex) {
                Activator.log((Exception)((Object)ex));
            }
            scrolledComposite.setContent((Control)content);
            Point point = content.computeSize(-1, -1);
            scrolledComposite.setMinSize(point);
            scrolledComposite.layout(true);
            return composite;
        }
    }
}

