/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.util.ECPExportHandlerHelper;
import org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelper;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ExportProjectHelper {
    private static final String FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*" + FILE_EXTENSION + ")"};
    public static final String[] FILTER_EXTS = new String[]{"*" + FILE_EXTENSION};
    private static final String ECP_UI_PLUGIN_ID = "org.eclipse.emf.ecp.ui";
    private static final String FILE_DIALOG_HELPER_CLASS = "org.eclipse.emf.ecp.internal.ui.util.ECPFileDialogHelperImpl";

    private ExportProjectHelper() {
    }

    public static void exportProject(InternalProject internalProject, Shell shell) {
        ESLocalProject localProject = EMFStoreProvider.INSTANCE.getProjectSpace(internalProject);
        String filePath = ExportProjectHelper.getFilePathByFileDialog(shell, internalProject.getName());
        if (filePath == null) {
            return;
        }
        try {
            new ExportImportControllerExecutor(new File(filePath), (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Export.getExportProjectSpaceController((ProjectSpace)((ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI())));
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
    }

    private static String getFilePathByFileDialog(Shell shell, String modelElementName) {
        BundleContext bundleContext = FrameworkUtil.getBundle(ECPExportHandlerHelper.class).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(ECPFileDialogHelper.class);
        ECPFileDialogHelper fileDialogHelper = (ECPFileDialogHelper)bundleContext.getService(serviceReference);
        String result = fileDialogHelper.getPathForExport(shell, modelElementName);
        bundleContext.ungetService(serviceReference);
        return result;
    }
}

