/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.generator;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;

public class ViewProvider
implements IViewProvider {
    public VView generate(EObject eObject, Map<String, Object> context) {
        VView view = VViewFactory.eINSTANCE.createView();
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        for (EStructuralFeature feature : this.getValidFeatures(delegator, eObject)) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            control.setReadonly(this.isReadOnly(delegator, eObject, feature));
            view.getChildren().add((Object)control);
        }
        composedAdapterFactory.dispose();
        view.setRootEClass(eObject.eClass());
        return view;
    }

    private boolean isReadOnly(AdapterFactoryItemDelegator delegator, EObject owner, EStructuralFeature feature) {
        if (!feature.isChangeable()) {
            return true;
        }
        IItemPropertyDescriptor descriptor = delegator.getPropertyDescriptor((Object)owner, (Object)feature);
        return !descriptor.canSetProperty((Object)feature);
    }

    private boolean isInvalidFeature(EStructuralFeature feature) {
        return this.isContainerReference(feature) || this.isTransient(feature) || this.isVolatile(feature);
    }

    private boolean isContainerReference(EStructuralFeature feature) {
        EReference reference;
        return feature instanceof EReference && (reference = (EReference)feature).isContainer();
    }

    private boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient();
    }

    private boolean isVolatile(EStructuralFeature feature) {
        return feature.isVolatile();
    }

    private Set<EStructuralFeature> getValidFeatures(AdapterFactoryItemDelegator itemDelegator, EObject eObject) {
        EList features = eObject.eClass().getEAllStructuralFeatures();
        LinkedHashSet<EStructuralFeature> featuresToAdd = new LinkedHashSet<EStructuralFeature>();
        IItemPropertyDescriptor propertyDescriptor = null;
        for (EStructuralFeature feature : features) {
            propertyDescriptor = itemDelegator.getPropertyDescriptor((Object)eObject, (Object)feature);
            if (propertyDescriptor == null || this.isInvalidFeature(feature)) continue;
            featuresToAdd.add(feature);
        }
        return featuresToAdd;
    }

    public int canRender(EObject eObject, Map<String, Object> context) {
        return 1;
    }
}

