/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.execution.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edapt.declaration.LibraryImplementation;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.execution.ValidationLevel;
import org.eclipse.emf.edapt.internal.migration.execution.internal.MigratorCommandLineOption;

public class MigratorCommandLine {
    private final List<URI> modelURIs = new ArrayList<URI>();
    private URI historyURI = null;
    private int sourceReleaseNumber = -1;
    private int targetReleaseNumber = -1;
    private ValidationLevel level = ValidationLevel.CUSTOM_MIGRATION;
    private boolean backup = false;
    private final List<Class<? extends OperationImplementation>> operations = new ArrayList<Class<? extends OperationImplementation>>();
    private final List<Class<? extends LibraryImplementation>> libraries = new ArrayList<Class<? extends LibraryImplementation>>();

    public MigratorCommandLine(URI historyURI, List<URI> modelURIs, int sourceReleaseNumber, int targetReleaseNumber, ValidationLevel level, boolean backup, List<Class<? extends LibraryImplementation>> libraries, List<Class<? extends OperationImplementation>> operations) {
        this.historyURI = historyURI;
        this.modelURIs.addAll(modelURIs);
        this.sourceReleaseNumber = sourceReleaseNumber;
        this.targetReleaseNumber = targetReleaseNumber;
        this.level = level;
        this.backup = backup;
        this.libraries.addAll(libraries);
        this.operations.addAll(operations);
    }

    public MigratorCommandLine(String[] args) {
        MigratorCommandLineOption option = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                option = MigratorCommandLineOption.getOption(arg.charAt(1));
                if (option == MigratorCommandLineOption.BACKUP) {
                    this.backup = true;
                }
            } else if (option == null) {
                URI modelURI = URIUtils.getURI((String)this.unquote(arg));
                this.modelURIs.add(modelURI);
            } else {
                switch (option) {
                    case HISTORY: {
                        this.historyURI = URIUtils.getURI((String)this.unquote(arg));
                        break;
                    }
                    case SOURCE_RELEASE: {
                        this.sourceReleaseNumber = Integer.parseInt(arg);
                        break;
                    }
                    case TARGET_RELEASE: {
                        this.targetReleaseNumber = Integer.parseInt(arg);
                        break;
                    }
                    case VALIDATION_LEVEL: {
                        this.level = ValidationLevel.valueOf(arg);
                        break;
                    }
                    case LIBRARY: {
                        Class<?> cl;
                        try {
                            cl = Class.forName(arg);
                            this.libraries.add(cl);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Library not found: " + arg);
                        }
                        break;
                    }
                    case OPERATION: {
                        Class<?> cl;
                        try {
                            cl = Class.forName(arg);
                            this.operations.add(cl);
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println("Operation not found: " + arg);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public String getCommandLine() {
        String argument = "";
        for (URI modelURI : this.modelURIs) {
            String modelFilename = modelURI.toFileString();
            modelFilename = this.quoteSpace(modelFilename);
            argument = String.valueOf(argument) + modelFilename + " ";
        }
        String historyFilename = this.historyURI.toFileString();
        historyFilename = this.quoteSpace(historyFilename);
        argument = String.valueOf(argument) + MigratorCommandLineOption.HISTORY.toOptionPrefix() + historyFilename + " ";
        if (this.sourceReleaseNumber != -1) {
            argument = String.valueOf(argument) + MigratorCommandLineOption.SOURCE_RELEASE.toOptionPrefix() + this.sourceReleaseNumber + " ";
        }
        if (this.targetReleaseNumber != -1) {
            argument = String.valueOf(argument) + MigratorCommandLineOption.TARGET_RELEASE.toOptionPrefix() + this.targetReleaseNumber + " ";
        }
        argument = String.valueOf(argument) + MigratorCommandLineOption.VALIDATION_LEVEL.toOptionPrefix() + this.level.toString() + " ";
        if (this.backup) {
            argument = String.valueOf(argument) + MigratorCommandLineOption.BACKUP.toOptionPrefix() + " ";
        }
        if (!this.libraries.isEmpty()) {
            argument = String.valueOf(argument) + MigratorCommandLineOption.LIBRARY.toOptionPrefix();
            for (Class<? extends LibraryImplementation> clazz : this.libraries) {
                argument = String.valueOf(argument) + clazz.getName() + " ";
            }
        }
        if (!this.operations.isEmpty()) {
            argument = String.valueOf(argument) + MigratorCommandLineOption.OPERATION.toOptionPrefix();
            for (Class<? extends LibraryImplementation> clazz : this.operations) {
                argument = String.valueOf(argument) + clazz.getName() + " ";
            }
        }
        return argument;
    }

    public List<URI> getModelURIs() {
        return this.modelURIs;
    }

    public URI getHistoryURI() {
        return this.historyURI;
    }

    public int getSourceReleaseNumber() {
        return this.sourceReleaseNumber;
    }

    public int getTargetReleaseNumber() {
        return this.targetReleaseNumber;
    }

    public ValidationLevel getLevel() {
        return this.level;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public List<Class<? extends OperationImplementation>> getOperations() {
        return this.operations;
    }

    public List<Class<? extends LibraryImplementation>> getLibraries() {
        return this.libraries;
    }

    private String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private String quoteSpace(String string) {
        if (string.contains(" ")) {
            string = "\"" + string + "\"";
        }
        return string;
    }
}

