/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.label;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.internal.core.services.label.BundleResolver;
import org.eclipse.emfforms.internal.core.services.label.BundleResolverImpl;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleChangeListener;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class EMFFormsLabelProviderImpl
implements EMFFormsLabelProvider,
EMFFormsLocaleChangeListener {
    private static final String DISPLAY_NAME = "_UI_%1$s_%2$s_feature";
    private static final String DESCRIPTION = "_UI_%1$s_%2$s_description";
    private static final String DESCRIPTION_COMPOSITE = "_UI_PropertyDescriptor_description";
    private static final String TYPE = "_UI_%1$s_type";
    private EMFFormsDatabinding emfFormsDatabinding;
    private EMFFormsLocalizationService localizationService;
    private ReportService reportService;
    private BundleResolver bundleResolver = new BundleResolverImpl();
    private final Map<DisplayNameKey, WritableValue> displayKeyObservableMap = new LinkedHashMap<DisplayNameKey, WritableValue>();
    private final Map<DescriptionKey, WritableValue> descriptionKeyObservableMap = new LinkedHashMap<DescriptionKey, WritableValue>();
    private EMFFormsLocaleProvider localeProvider;
    private ServiceReference<EMFFormsLabelProvider> defaultLabelProviderReference;
    private EMFFormsLabelProvider labelProviderDefault;

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    protected void setEMFFormsLocalizationService(EMFFormsLocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    protected void setEMFFormsLocaleProvider(EMFFormsLocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
        this.localeProvider.addEMFFormsLocaleChangeListener((EMFFormsLocaleChangeListener)this);
    }

    protected void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        this.defaultLabelProviderReference = (ServiceReference)bundleContext.getServiceReferences(EMFFormsLabelProvider.class, "(service.ranking=1)").iterator().next();
        this.labelProviderDefault = (EMFFormsLabelProvider)bundleContext.getService(this.defaultLabelProviderReference);
    }

    protected void deactivate(BundleContext bundleContext) {
        bundleContext.ungetService(this.defaultLabelProviderReference);
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EClass eContainingClass = structuralFeature.getEContainingClass();
        try {
            bundle = this.bundleResolver.getEditBundle(eContainingClass);
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, 1));
            this.reportService.report(new AbstractReport("Using fallback", 1));
            return this.labelProviderDefault.getDisplayName(domainModelReference);
        }
        String key = String.format(DISPLAY_NAME, eContainingClass.getName(), structuralFeature.getName());
        WritableValue value = this.getObservableValue(this.getDisplayName(bundle, key));
        this.displayKeyObservableMap.put(new DisplayNameKey(key, bundle), value);
        return value;
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        try {
            bundle = this.bundleResolver.getEditBundle(structuralFeature.getEContainingClass());
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, 1));
            this.reportService.report(new AbstractReport("Using fallback", 1));
            return this.labelProviderDefault.getDisplayName(domainModelReference, rootObject);
        }
        String key = String.format(DISPLAY_NAME, structuralFeature.getEContainingClass().getName(), structuralFeature.getName());
        WritableValue displayObserveValue = this.getObservableValue(this.getDisplayName(bundle, key));
        this.displayKeyObservableMap.put(new DisplayNameKey(key, bundle), displayObserveValue);
        return displayObserveValue;
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EClass eContainingClass = structuralFeature.getEContainingClass();
        try {
            bundle = this.bundleResolver.getEditBundle(eContainingClass);
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, 1));
            this.reportService.report(new AbstractReport("Using fallback", 1));
            return this.labelProviderDefault.getDescription(domainModelReference);
        }
        WritableValue writableValue = this.getObservableValue(this.getDescription(eContainingClass.getName(), structuralFeature.getName(), bundle));
        this.descriptionKeyObservableMap.put(new DescriptionKey(eContainingClass.getName(), structuralFeature.getName(), bundle), writableValue);
        return writableValue;
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference, EObject rootObject) throws NoLabelFoundException {
        Bundle bundle;
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            throw new NoLabelFoundException((Exception)((Object)ex));
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        try {
            bundle = this.bundleResolver.getEditBundle(structuralFeature.getEContainingClass());
        }
        catch (BundleResolver.NoBundleFoundException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex, 1));
            this.reportService.report(new AbstractReport("Using fallback", 1));
            return this.labelProviderDefault.getDescription(domainModelReference, rootObject);
        }
        WritableValue writableValue = this.getObservableValue(this.getDescription(structuralFeature.getEContainingClass().getName(), structuralFeature.getName(), bundle));
        this.descriptionKeyObservableMap.put(new DescriptionKey(structuralFeature.getEContainingClass().getName(), structuralFeature.getName(), bundle), writableValue);
        return writableValue;
    }

    private WritableValue getObservableValue(String value) {
        return new WritableValue((Object)value, String.class);
    }

    private String getDisplayName(Bundle bundle, String key) {
        return this.localizationService.getString(bundle, key);
    }

    private String getDescription(String eClassName, String featureName, Bundle bundle) {
        String keyDefault = String.format(DESCRIPTION, eClassName, featureName);
        if (this.localizationService.hasKey(bundle, keyDefault)) {
            return this.localizationService.getString(bundle, keyDefault);
        }
        String descriptionWithSubstitution = this.localizationService.getString(bundle, DESCRIPTION_COMPOSITE);
        String key = String.format(DISPLAY_NAME, eClassName, featureName);
        String featureSubstitution = this.getDisplayName(bundle, key);
        String eObjectSubstitution = this.localizationService.getString(bundle, String.format(TYPE, eClassName));
        return MessageFormat.format(descriptionWithSubstitution, featureSubstitution, eObjectSubstitution);
    }

    public void notifyLocaleChange() {
        WritableValue writableValue;
        for (DisplayNameKey displayNameKey : this.displayKeyObservableMap.keySet()) {
            writableValue = this.displayKeyObservableMap.get(displayNameKey);
            writableValue.setValue((Object)this.getDisplayName(displayNameKey.getBundle(), displayNameKey.getKey()));
        }
        for (DescriptionKey descriptionKey : this.descriptionKeyObservableMap.keySet()) {
            writableValue = this.descriptionKeyObservableMap.get(descriptionKey);
            writableValue.setValue((Object)this.getDescription(descriptionKey.geteClassName(), descriptionKey.getFeatureName(), descriptionKey.getBundle()));
        }
    }

    private static class DescriptionKey {
        private final String eClassName;
        private final String featureName;
        private final Bundle bundle;

        public DescriptionKey(String eClassName, String featureName, Bundle bundle) {
            this.eClassName = eClassName;
            this.featureName = featureName;
            this.bundle = bundle;
        }

        Bundle getBundle() {
            return this.bundle;
        }

        String geteClassName() {
            return this.eClassName;
        }

        String getFeatureName() {
            return this.featureName;
        }
    }

    private static class DisplayNameKey {
        private final String key;
        private final Bundle bundle;

        public DisplayNameKey(String key, Bundle bundle) {
            this.key = key;
            this.bundle = bundle;
        }

        String getKey() {
            return this.key;
        }

        Bundle getBundle() {
            return this.bundle;
        }
    }
}

