/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.layout;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.swt.Activator;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.layout.LayoutProvider;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public final class LayoutProviderHelper {
    private static final String CLASS_CANNOT_BE_RESOLVED = "%1$s cannot be loaded because bundle %2$s cannot be resolved.";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.ecp.ui.view.swt.layoutProvider";
    private static List<LayoutProvider> layoutProviders = new ArrayList<LayoutProvider>();

    private LayoutProviderHelper() {
    }

    private static synchronized List<LayoutProvider> getLayoutProvider() {
        if (layoutProviders == null || layoutProviders.isEmpty()) {
            LayoutProviderHelper.readLayoutProviders();
        }
        return layoutProviders;
    }

    private static void readLayoutProviders() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String clazz = e.getAttribute(CLASS);
                Class resolvedClass = LayoutProviderHelper.loadClass(e.getContributor().getName(), clazz);
                Constructor controlConstructor = resolvedClass.getConstructor(new Class[0]);
                LayoutProvider layoutProvider = (LayoutProvider)controlConstructor.newInstance(new Object[0]);
                layoutProviders.add(layoutProvider);
            }
            catch (ClassNotFoundException ex) {
                Activator.log(ex);
            }
            catch (NoSuchMethodException ex) {
                Activator.log(ex);
            }
            catch (SecurityException ex) {
                Activator.log(ex);
            }
            catch (InstantiationException ex) {
                Activator.log(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.log(ex);
            }
            catch (IllegalArgumentException ex) {
                Activator.log(ex);
            }
            catch (InvocationTargetException ex) {
                Activator.log(ex);
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.format(CLASS_CANNOT_BE_RESOLVED, clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    public static Layout getColumnLayout(int numColumns, boolean equalWidth) {
        LayoutProviderHelper.checkProviderLength();
        return LayoutProviderHelper.getLayoutProvider().get(0).getColumnLayout(numColumns, equalWidth);
    }

    public static Object getLayoutData(SWTGridCell gridCell, SWTGridDescription controlGridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, EObject domainModel, Control control) {
        LayoutProviderHelper.checkProviderLength();
        return LayoutProviderHelper.getLayoutProvider().get(0).getLayoutData(gridCell, controlGridDescription, currentRowGridDescription, fullGridDescription, vElement, domainModel, control);
    }

    private static void checkProviderLength() {
        if (LayoutProviderHelper.getLayoutProvider().size() != 1) {
            StringBuilder sb = new StringBuilder("There must be exactly one LayoutProvider!");
            sb.append("\n");
            sb.append(String.format("Found %1$d providers.", LayoutProviderHelper.getLayoutProvider().size()));
            for (LayoutProvider layoutProvider : LayoutProviderHelper.getLayoutProvider()) {
                sb.append("\n");
                sb.append(layoutProvider.toString());
            }
            throw new IllegalStateException(sb.toString());
        }
    }

    public static Object getSpanningLayoutData(int spanX, int spanY) {
        LayoutProviderHelper.checkProviderLength();
        return LayoutProviderHelper.getLayoutProvider().get(0).getSpanningLayoutData(spanX, spanY);
    }

    public static void addLayoutProvider(LayoutProvider layoutProvider) {
        layoutProviders.add(layoutProvider);
    }
}

