/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail.util;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.emfforms.StaticSelectionCommandAction;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class CreateChildAction
extends StaticSelectionCommandAction {
    private final CommandParameter descriptor;
    private final EditingDomain editingDomain;
    private final ISelectionProvider selectionProvider;
    private final EObject parent;
    private final CreateElementCallback createElementCallback;

    public CreateChildAction(EObject parent, EditingDomain editingDomain, ISelectionProvider selectionProvider, CommandParameter descriptor, CreateElementCallback createElementCallback) {
        super(editingDomain);
        this.parent = parent;
        this.descriptor = descriptor;
        this.selectionProvider = selectionProvider;
        this.configureAction(selectionProvider.getSelection());
        this.editingDomain = editingDomain;
        this.createElementCallback = createElementCallback;
    }

    @Override
    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (collection.size() == 1) {
            Object owner = collection.iterator().next();
            return CreateChildCommand.create((EditingDomain)editingDomain, owner, (Object)this.descriptor, collection);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public void run() {
        EReference reference = this.descriptor.getEReference();
        EObject newObject = this.descriptor.getEValue();
        Command addCommand = reference.getUpperBound() == 1 ? SetCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)reference, (Object)newObject) : AddCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)reference, (Object)newObject);
        this.editingDomain.getCommandStack().execute(addCommand);
        boolean callbackResult = true;
        if (this.createElementCallback != null) {
            callbackResult = this.createElementCallback.beforeCreateElement(newObject);
        }
        if (callbackResult) {
            if (this.selectionProvider instanceof Viewer) {
                ((Viewer)this.selectionProvider).refresh();
            }
            this.selectionProvider.setSelection((ISelection)new StructuredSelection((Object)newObject));
        } else {
            addCommand.undo();
        }
    }
}

