/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding.index;

import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.databinding.internal.EMFValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.index.EMFIndexedValueProperty;
import org.eclipse.emfforms.internal.core.services.databinding.index.EMFIndexedValuePropertyDelegator;
import org.eclipse.emfforms.internal.core.services.databinding.index.IllegalListTypeException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class IndexDomainModelReferenceConverter
implements DomainModelReferenceConverter {
    private EMFFormsDatabinding emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabinding> databindingServiceReference;

    void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    void unsetEMFFormsDatabinding() {
        this.emfFormsDatabinding = null;
    }

    protected final void activate(BundleContext bundleContext) {
        this.databindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        this.setEMFFormsDatabinding((EMFFormsDatabinding)bundleContext.getService(this.databindingServiceReference));
    }

    protected final void deactivate(BundleContext bundleContext) {
        this.unsetEMFFormsDatabinding();
        bundleContext.ungetService(this.databindingServiceReference);
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (domainModelReference instanceof VIndexDomainModelReference) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFValueProperty valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VIndexDomainModelReference.");
        }
        VIndexDomainModelReference indexReference = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        if (indexReference.getPrefixDMR() != null) {
            IValueProperty prefixProperty = this.emfFormsDatabinding.getValueProperty(indexReference.getPrefixDMR(), object);
            valueProperty = new EMFIndexedValuePropertyDelegator(this.getEditingDomain(object), indexReference.getIndex(), prefixProperty, (EStructuralFeature)EStructuralFeature.class.cast(prefixProperty.getValueType()));
        } else {
            if (indexReference.getDomainModelEFeature() == null) {
                throw new DatabindingFailedException("The field domainModelEFeature of the given VIndexDomainModelReference must not be null.");
            }
            this.checkListType(indexReference.getDomainModelEFeature());
            EList referencePath = indexReference.getDomainModelEReferencePath();
            if (referencePath.isEmpty()) {
                valueProperty = new EMFIndexedValueProperty(this.getEditingDomain(object), indexReference.getIndex(), indexReference.getDomainModelEFeature());
            } else {
                IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
                int i = 1;
                while (i < referencePath.size()) {
                    emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                    ++i;
                }
                EMFIndexedValueProperty indexedValueProperty = new EMFIndexedValueProperty(this.getEditingDomain(object), indexReference.getIndex(), indexReference.getDomainModelEFeature());
                valueProperty = emfValueProperty.value((IValueProperty)indexedValueProperty);
            }
        }
        return valueProperty.value(this.emfFormsDatabinding.getValueProperty(indexReference.getTargetDMR(), object));
    }

    public IListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        EMFValueProperty valueProperty;
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VIndexDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VIndexDomainModelReference.");
        }
        VIndexDomainModelReference indexReference = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(domainModelReference);
        if (indexReference.getPrefixDMR() != null) {
            IValueProperty prefixProperty = this.emfFormsDatabinding.getValueProperty(indexReference.getPrefixDMR(), object);
            valueProperty = new EMFIndexedValuePropertyDelegator(this.getEditingDomain(object), indexReference.getIndex(), prefixProperty, (EStructuralFeature)EStructuralFeature.class.cast(prefixProperty.getValueType()));
        } else {
            if (indexReference.getDomainModelEFeature() == null) {
                throw new DatabindingFailedException("The field domainModelEFeature of the given VIndexDomainModelReference must not be null.");
            }
            this.checkListType(indexReference.getDomainModelEFeature());
            EList referencePath = indexReference.getDomainModelEReferencePath();
            if (referencePath.isEmpty()) {
                valueProperty = new EMFIndexedValueProperty(this.getEditingDomain(object), indexReference.getIndex(), indexReference.getDomainModelEFeature());
            } else {
                IEMFEditValueProperty emfValueProperty = EMFEditProperties.value((EditingDomain)this.getEditingDomain(object), (EStructuralFeature)((EStructuralFeature)referencePath.get(0)));
                int i = 1;
                while (i < referencePath.size()) {
                    emfValueProperty = emfValueProperty.value((EStructuralFeature)referencePath.get(i));
                    ++i;
                }
                EMFIndexedValueProperty indexedValueProperty = new EMFIndexedValueProperty(this.getEditingDomain(object), indexReference.getIndex(), indexReference.getDomainModelEFeature());
                valueProperty = emfValueProperty.value((IValueProperty)indexedValueProperty);
            }
        }
        return valueProperty.list(this.emfFormsDatabinding.getListProperty(indexReference.getTargetDMR(), object));
    }

    private void checkListType(EStructuralFeature structuralFeature) throws IllegalListTypeException {
        if (!structuralFeature.isMany()) {
            throw new IllegalListTypeException("The VIndexDomainModelReference's domainModelEFeature must reference a list.");
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new IllegalListTypeException("The VIndexDomainModelReference's domainModelEFeature must reference a list of EObjects.");
        }
    }

    private EditingDomain getEditingDomain(EObject object) throws DatabindingFailedException {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object);
    }
}

