/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.treemasterdetail;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.swt.treemasterdetail.helpers.EcoreHelpers;
import org.eclipse.emfforms.spi.swt.treemasterdetail.TreeMasterDetailComposite;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateChildAction;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.CreateElementCallback;
import org.eclipse.emfforms.spi.swt.treemasterdetail.util.MasterDetailAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.osgi.framework.FrameworkUtil;

public class TreeMasterDetailMenuListener
implements IMenuListener {
    private final Collection<MasterDetailAction> rightClickActions;
    private final ChildrenDescriptorCollector childrenDescriptorCollector;
    private final MenuManager menuMgr;
    private final TreeViewer treeViewer;
    private final EditingDomain editingDomain;
    private final CreateElementCallback createElementCallback;

    public TreeMasterDetailMenuListener(ChildrenDescriptorCollector childrenDescriptorCollector, MenuManager menuMgr, TreeViewer treeViewer, EditingDomain editingDomain, Collection<MasterDetailAction> rightClickActions, CreateElementCallback createElementCallback) {
        this.childrenDescriptorCollector = childrenDescriptorCollector;
        this.menuMgr = menuMgr;
        this.treeViewer = treeViewer;
        this.editingDomain = editingDomain;
        this.rightClickActions = rightClickActions;
        this.createElementCallback = createElementCallback;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.treeViewer.getSelection().isEmpty()) {
            return;
        }
        if (this.treeViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            if (selection.size() == 1 && selection.getFirstElement() instanceof EObject) {
                EObject eObject = (EObject)selection.getFirstElement();
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
                if (domain == null) {
                    return;
                }
                Collection descriptors = this.childrenDescriptorCollector.getDescriptors(eObject);
                this.fillContextMenu(manager, descriptors, this.editingDomain, eObject);
            }
            manager.add((IContributionItem)new Separator());
            this.addDeleteActionToContextMenu(this.editingDomain, (IMenuManager)this.menuMgr, selection);
            if (selection.getFirstElement() instanceof EObject && this.rightClickActions != null) {
                final EObject eSelectedObject = (EObject)selection.getFirstElement();
                for (final MasterDetailAction menuAction : this.rightClickActions) {
                    if (!menuAction.shouldShow(eSelectedObject)) continue;
                    Action newAction = new Action(){

                        public void run() {
                            super.run();
                            menuAction.execute(eSelectedObject);
                        }
                    };
                    newAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)menuAction)).getClass()).getResource(menuAction.getImagePath())));
                    newAction.setText(menuAction.getLabel());
                    manager.add((IAction)newAction);
                }
            }
        }
    }

    private void fillContextMenu(IMenuManager manager, Collection<?> descriptors, EditingDomain domain, EObject eObject) {
        for (Object descriptor : descriptors) {
            CommandParameter cp = (CommandParameter)descriptor;
            if (!CommandParameter.class.isInstance(descriptor) || cp.getEReference() == null || EcoreHelpers.isGenericFeature(cp.getFeature()) || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            manager.add((IAction)new CreateChildAction(eObject, domain, (ISelectionProvider)this.treeViewer, cp, this.createElementCallback));
        }
    }

    private void addDeleteActionToContextMenu(final EditingDomain editingDomain, IMenuManager manager, IStructuredSelection selection) {
        final Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Collection)selection.toList());
        if (!removeCommand.canExecute()) {
            return;
        }
        Action deleteAction = new Action(){

            public void run() {
                super.run();
                editingDomain.getCommandStack().execute(removeCommand);
            }
        };
        deleteAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(TreeMasterDetailComposite.class).getResource("icons/delete.png")));
        deleteAction.setText("Delete");
        manager.add((IAction)deleteAction);
    }
}

