/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.provider.xmi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.internal.view.model.provider.xmi.Activator;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceFactoryImpl;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;

public final class ViewModelFileExtensionsManager {
    private static final String FILTER_VALUE_ATTRIBUTE = "value";
    private static final String FILTER_KEY_ATTRIBUTE = "key";
    private static final String FILTER_ELEMENT = "filter";
    private static final String FILE_EXTENSION = "org.eclipse.emf.ecp.view.model.provider.xmi.file";
    private static final String FILEPATH_ATTRIBUTE = "filePath";
    private final Map<EClass, Map<VView, ExtensionDescription>> map = new LinkedHashMap<EClass, Map<VView, ExtensionDescription>>();
    private static ViewModelFileExtensionsManager instance;
    private static final int FILTER_NOT_MATCHED = Integer.MIN_VALUE;

    private ViewModelFileExtensionsManager() {
    }

    public static ViewModelFileExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ViewModelFileExtensionsManager();
            instance.init();
        }
        return instance;
    }

    private void init() {
        Map<URI, ExtensionDescription> extensionURIS = ViewModelFileExtensionsManager.getExtensionURIS();
        for (URI uri : extensionURIS.keySet()) {
            VView view;
            Resource resource = ViewModelFileExtensionsManager.loadResource(uri);
            EObject eObject = (EObject)resource.getContents().get(0);
            if (!(eObject instanceof VView) || (view = (VView)eObject).getRootEClass() == null) continue;
            ExtensionDescription extensionDescription = extensionURIS.get(uri);
            this.registerView(view, extensionDescription);
        }
    }

    void registerView(VView view, ExtensionDescription extensionDescription) {
        if (!this.map.containsKey(view.getRootEClass())) {
            this.map.put(view.getRootEClass(), new LinkedHashMap());
        }
        this.map.get(view.getRootEClass()).put(view, extensionDescription);
    }

    public static Resource loadResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new VViewResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://org/eclipse/emf/ecp/view/model/170", (Object)VViewPackage.eINSTANCE);
        Resource resource = resourceSet.createResource(uri);
        HashMap loadOptions = new HashMap();
        try {
            resource.load(loadOptions);
        }
        catch (IOException exception) {
            Activator.getReportService().report(new AbstractReport((Throwable)exception));
        }
        return resource;
    }

    public static void dispose() {
        instance = null;
    }

    public static Map<URI, ExtensionDescription> getExtensionURIS() {
        LinkedHashMap<URI, ExtensionDescription> ret = new LinkedHashMap<URI, ExtensionDescription>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_EXTENSION);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        IConfigurationElement[] iConfigurationElementArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement file = iConfigurationElementArray[n2];
            String bundleId = file.getContributor().getName();
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            IConfigurationElement[] children = file.getChildren(FILTER_ELEMENT);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                String key = child.getAttribute(FILTER_KEY_ATTRIBUTE);
                String value = child.getAttribute(FILTER_VALUE_ATTRIBUTE);
                keyValuePairs.put(key, value);
                ++n4;
            }
            String bundleName = file.getContributor().getName();
            String path = String.valueOf(bundleName) + '/' + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            if (converter.exists(uri, null)) {
                ret.put(uri, new ExtensionDescription(keyValuePairs, bundleId));
            } else {
                uri = URI.createPlatformResourceURI((String)filePath, (boolean)false);
                if (converter.exists(uri, null)) {
                    ret.put(uri, new ExtensionDescription(keyValuePairs, bundleId));
                }
            }
            ++n2;
        }
        return ret;
    }

    public boolean hasViewModelFor(EObject eObject, VViewModelProperties properties) {
        return !this.findBestFittingViews(eObject, properties).isEmpty();
    }

    public VView createView(EObject eObject, VViewModelProperties properties) {
        ReportService reportService;
        List<VView> bestFitting = this.findBestFittingViews(eObject, properties);
        if (bestFitting.isEmpty()) {
            ReportService reportService2 = Activator.getReportService();
            if (reportService2 != null) {
                reportService2.report(new AbstractReport("No view models have been found for the given View Model Loading Properties. This should have not been called!", 4));
            }
            return null;
        }
        if (bestFitting.size() != 1 && (reportService = Activator.getReportService()) != null) {
            reportService.report(new AbstractReport("Multiple view models have been found for the given View Model Loading Properties.", 2));
        }
        VView fittingView = bestFitting.get(0);
        VView copiedView = (VView)EcoreUtil.copy((EObject)fittingView);
        String bundleId = this.map.get(fittingView.getRootEClass()).get(fittingView).getBundleId();
        copiedView.eAdapters().add((Object)new LocalizationAdapter(){

            public String localize(String key) {
                return LocalizationServiceHelper.getString((Bundle)Platform.getBundle((String)bundleId), (String)key);
            }
        });
        copiedView.setLoadingProperties((VViewModelProperties)EcoreUtil.copy((EObject)properties));
        return copiedView;
    }

    private List<VView> findBestFittingViews(EObject eObject, VViewModelProperties properties) {
        Map<VView, ExtensionDescription> viewMap = this.map.get(eObject.eClass());
        if (viewMap == null) {
            return Collections.emptyList();
        }
        ArrayList<VView> bestFitting = new ArrayList<VView>();
        int maxNumberFittingKeyValues = -1;
        VViewModelProperties propertiesToCheck = properties;
        if (propertiesToCheck == null) {
            propertiesToCheck = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        }
        for (VView view : viewMap.keySet()) {
            Map<String, String> viewFilter = viewMap.get(view).getKeyValuPairs();
            int currentFittingKeyValues = 0;
            for (String viewFilterKey : viewFilter.keySet()) {
                if (propertiesToCheck.containsKey(viewFilterKey)) {
                    Object contextValue = propertiesToCheck.get(viewFilterKey);
                    String viewFilterValue = viewFilter.get(viewFilterKey);
                    if (contextValue.toString().equalsIgnoreCase(viewFilterValue)) {
                        ++currentFittingKeyValues;
                        continue;
                    }
                    currentFittingKeyValues = Integer.MIN_VALUE;
                    break;
                }
                currentFittingKeyValues = Integer.MIN_VALUE;
                break;
            }
            if (currentFittingKeyValues == Integer.MIN_VALUE) continue;
            if (currentFittingKeyValues > maxNumberFittingKeyValues) {
                maxNumberFittingKeyValues = currentFittingKeyValues;
                bestFitting.clear();
                bestFitting.add(view);
                continue;
            }
            if (currentFittingKeyValues != maxNumberFittingKeyValues) continue;
            bestFitting.add(view);
        }
        return bestFitting;
    }

    static final class ExtensionDescription {
        private final Map<String, String> keyValuPairs;
        private final String bundleId;

        ExtensionDescription(Map<String, String> keyValuPairs, String bundleId) {
            this.keyValuPairs = keyValuPairs;
            this.bundleId = bundleId;
        }

        Map<String, String> getKeyValuPairs() {
            return this.keyValuPairs;
        }

        String getBundleId() {
            return this.bundleId;
        }
    }
}

