/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.unset;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.unset.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;

public class UnsetService
implements ViewModelService {
    private static final String DOMAIN_MODEL_NULL_EXCEPTION = "Domain model must not be null.";
    private static final String VIEW_MODEL_NULL_EXCEPTION = "View model must not be null.";
    private ViewModelContext context;
    private ModelChangeAddRemoveListener viewChangeListener;
    private final Map<EObject, Set<FeatureWrapper>> objectToFeatureMap = new LinkedHashMap<EObject, Set<FeatureWrapper>>();
    private final Map<FeatureWrapper, Set<VControl>> settingToControlMap = new LinkedHashMap<FeatureWrapper, Set<VControl>>();
    private final Set<VControl> hiddenControlsDuringInit = new LinkedHashSet<VControl>();

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.viewChangeListener = new ModelChangeAddRemoveListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                    EObject notifier = notification.getNotifier();
                    Notification rawNotification = notification.getRawNotification();
                    if (rawNotification.getNewBooleanValue()) {
                        UnsetService.this.show((VElement)notifier);
                        return;
                    }
                    UnsetService.this.hide((VElement)notifier);
                }
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyRemove(Notifier notifier) {
            }
        };
        context.registerViewChangeListener((ModelChangeListener)this.viewChangeListener);
        VElement view = context.getViewModel();
        if (view == null) {
            throw new IllegalStateException(VIEW_MODEL_NULL_EXCEPTION);
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException(DOMAIN_MODEL_NULL_EXCEPTION);
        }
        this.initMaps(view, false);
        this.unsetInitialHiddenControls();
    }

    private void initMaps(VElement view, boolean parentInvisible) {
        if (!view.isVisible() || parentInvisible) {
            if (view instanceof VControl) {
                this.hiddenControlsDuringInit.add((VControl)view);
            }
            parentInvisible = true;
        }
        if (view instanceof VControl) {
            this.addControlToMap((VControl)view);
        } else {
            EList children = view.eContents();
            for (EObject child : children) {
                if (child == null || !(child instanceof VElement)) continue;
                this.initMaps((VElement)child, parentInvisible);
            }
        }
    }

    private void unsetInitialHiddenControls() {
        for (VControl control : this.hiddenControlsDuringInit) {
            this.removeControlFromMapAndUnsetIfNeeded(control);
        }
    }

    private void addControlToMap(VControl control) {
        IObservableValue observableValue;
        if (control.getDomainModelReference() == null) {
            Activator.getDefault().getReportService().report(new AbstractReport(String.format("The provided control [%1$s] has no defined DMR.", control), 1));
            return;
        }
        try {
            observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(control.getDomainModelReference(), this.context.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        if (!this.objectToFeatureMap.containsKey(eObject)) {
            this.objectToFeatureMap.put(eObject, new LinkedHashSet());
        }
        Set<FeatureWrapper> features = this.objectToFeatureMap.get(eObject);
        FeatureWrapper wrapper = null;
        for (FeatureWrapper w : features) {
            if (!w.isWrapperFor(structuralFeature)) continue;
            wrapper = w;
            break;
        }
        if (wrapper == null) {
            wrapper = new FeatureWrapper(structuralFeature);
            features.add(wrapper);
        }
        if (!this.settingToControlMap.containsKey(wrapper)) {
            this.settingToControlMap.put(wrapper, new LinkedHashSet());
        }
        this.settingToControlMap.get(wrapper).add(control);
    }

    private void removeControlFromMapAndUnsetIfNeeded(VControl control) {
        IObservableValue observableValue;
        try {
            observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(control.getDomainModelReference(), this.context.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return;
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        Set<FeatureWrapper> wrappers = this.objectToFeatureMap.get(eObject);
        FeatureWrapper wrapper = null;
        if (wrappers == null) {
            return;
        }
        for (FeatureWrapper w : wrappers) {
            if (!w.isWrapperFor(structuralFeature)) continue;
            wrapper = w;
        }
        Set<VControl> visibleControls = this.settingToControlMap.get(wrapper);
        visibleControls.remove(control);
        if (visibleControls.isEmpty()) {
            eObject.eUnset(structuralFeature);
        }
    }

    private void show(VElement element) {
        if (element instanceof VControl) {
            this.addControlToMap((VControl)element);
            return;
        }
        EList children = element.eContents();
        for (EObject child : children) {
            VElement childElement;
            if (child == null || !(child instanceof VElement) || !(childElement = (VElement)child).isVisible()) continue;
            this.show(childElement);
        }
    }

    private void hide(VElement element) {
        if (element instanceof VControl) {
            this.removeControlFromMapAndUnsetIfNeeded((VControl)element);
            return;
        }
        TreeIterator iterator = element.eAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object == null || !(object instanceof VControl)) continue;
            this.removeControlFromMapAndUnsetIfNeeded((VControl)object);
        }
    }

    public void dispose() {
        this.context.unregisterViewChangeListener((ModelChangeListener)this.viewChangeListener);
    }

    public int getPriority() {
        return 5;
    }

    private class FeatureWrapper {
        private final EStructuralFeature feature;

        public FeatureWrapper(EStructuralFeature feature) {
            this.feature = feature;
        }

        public boolean isWrapperFor(EStructuralFeature featureToCompare) {
            return this.feature.equals(featureToCompare);
        }
    }
}

