/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.swt.ECPAdditionalRendererTester;
import org.eclipse.emf.ecp.view.spi.swt.reporting.ECPRendererDescriptionInitFailedReport;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RendererInitFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsAdditionalRendererService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class LegacyAdditionalRendererService
implements EMFFormsAdditionalRendererService<VElement> {
    private static final String ADDITIONAL_RENDER_EXTENSION = "org.eclipse.emf.ecp.ui.view.swt.additionalRenderers";
    private ReportService reportService;
    private final Map<ECPAdditionalRendererTester, Class<AbstractAdditionalSWTRenderer<VElement>>> legacyRenderer = new LinkedHashMap<ECPAdditionalRendererTester, Class<AbstractAdditionalSWTRenderer<VElement>>>();

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.readAdditionalRenderer(bundleContext);
    }

    private void readAdditionalRenderer(BundleContext bundleContext) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ADDITIONAL_RENDER_EXTENSION);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                try {
                    Class renderer = LegacyAdditionalRendererService.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("renderer"));
                    ECPAdditionalRendererTester tester = (ECPAdditionalRendererTester)configurationElement.createExecutableExtension("tester");
                    this.legacyRenderer.put(tester, renderer);
                }
                catch (CoreException ex) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)ex));
                }
                catch (ClassNotFoundException e) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)e));
                }
                catch (InvalidRegistryObjectException e) {
                    this.reportService.report((AbstractReport)new ECPRendererDescriptionInitFailedReport((Throwable)e));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }

    public boolean isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        boolean result = false;
        for (ECPAdditionalRendererTester tester : this.legacyRenderer.keySet()) {
            result |= tester.isApplicable(vElement, null);
        }
        return result;
    }

    public Collection<AbstractAdditionalSWTRenderer<VElement>> getRendererInstances(VElement vElement, ViewModelContext viewModelContext) {
        ArrayList<AbstractAdditionalSWTRenderer<VElement>> result = new ArrayList<AbstractAdditionalSWTRenderer<VElement>>();
        for (Class<AbstractAdditionalSWTRenderer<VElement>> renderer : this.getFittingRenderer(vElement, viewModelContext)) {
            AbstractAdditionalSWTRenderer<VElement> additionalRenderer = this.createRenderer(vElement, viewModelContext, this.reportService, renderer);
            additionalRenderer.init();
            result.add(additionalRenderer);
        }
        return result;
    }

    private Collection<Class<AbstractAdditionalSWTRenderer<VElement>>> getFittingRenderer(VElement vElement, ViewModelContext viewModelContext) {
        ArrayList<Class<AbstractAdditionalSWTRenderer<VElement>>> fitting = new ArrayList<Class<AbstractAdditionalSWTRenderer<VElement>>>();
        for (Map.Entry<ECPAdditionalRendererTester, Class<AbstractAdditionalSWTRenderer<VElement>>> entry : this.legacyRenderer.entrySet()) {
            if (!entry.getKey().isApplicable(vElement, viewModelContext)) continue;
            fitting.add(entry.getValue());
        }
        return fitting;
    }

    private AbstractAdditionalSWTRenderer<VElement> createRenderer(VElement vElement, ViewModelContext viewContext, ReportService reportService, Class<? extends AbstractAdditionalSWTRenderer<VElement>> rendererClass) {
        try {
            return rendererClass.getConstructor(vElement.getClass().getInterfaces()[0], ViewModelContext.class).newInstance(vElement, viewContext);
        }
        catch (InstantiationException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (IllegalArgumentException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (InvocationTargetException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (NoSuchMethodException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
        catch (SecurityException ex) {
            reportService.report((AbstractReport)new RendererInitFailedReport((Throwable)ex));
            throw new IllegalStateException(ex);
        }
    }
}

