/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.preview.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.DefaultReferenceService;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTView;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.model.preview.common.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ErrorViewPart;

public class Preview {
    private ECPSWTView render;
    private Adapter adapter;
    private VView view;
    private boolean updateAutomatic;
    private final Composite parent;
    private Composite composite;
    private EObject dummyData;

    public Preview(Composite parent) {
        this.parent = parent;
    }

    public void render(VView view, EObject sampleData) {
        if (this.adapter != null) {
            this.removeAdapter();
        }
        this.view = view;
        if (sampleData != null) {
            this.dummyData = sampleData;
        }
        this.internalRender(view);
    }

    public void registerForViewModelChanges() {
        if (this.view == null) {
            return;
        }
        if (this.adapter != null) {
            this.removeAdapter();
        }
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (!Preview.this.updateAutomatic) {
                    return;
                }
                if (notification.isTouch()) {
                    return;
                }
                if (((EStructuralFeature)EStructuralFeature.class.cast(notification.getFeature())).isTransient()) {
                    return;
                }
                if (VViewPackage.eINSTANCE.getDomainModelReference_ChangeListener() == notification.getFeature()) {
                    return;
                }
                Preview.this.internalRender(Preview.this.view);
            }
        };
        this.view.eAdapters().add((Object)this.adapter);
    }

    private void internalRender(VView view) {
        try {
            this.clear();
            EClass myPreviewEClass = view.getRootEClass();
            if (this.dummyData == null || this.dummyData.eClass() != myPreviewEClass) {
                this.dummyData = EcoreUtil.create((EClass)myPreviewEClass);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)new BasicCommandStack(), (ResourceSet)resourceSet);
                resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
                Resource resource = resourceSet.createResource(URI.createURI((String)"VIRTUAL_URI"));
                resource.getContents().add((Object)this.dummyData);
            }
            DefaultReferenceService previewRefServ = new DefaultReferenceService();
            VView copy = (VView)EcoreUtil.copy((EObject)view);
            copy.eAdapters().add((Object)new LocalizationAdapter(){

                public String localize(String key) {
                    return key;
                }
            });
            this.clearViewDiagnostics(copy);
            ViewModelContext viewModelContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)copy, this.dummyData, new ViewModelService[]{previewRefServ, new EMFDeleteServiceImpl()});
            this.composite = this.createComposite(this.parent);
            this.render = ECPSWTViewRenderer.INSTANCE.render(this.composite, viewModelContext);
            this.composite.layout();
            this.parent.layout();
        }
        catch (RuntimeException e) {
            this.displayError(e);
        }
        catch (ECPRendererException ex) {
            this.displayError((Exception)((Object)ex));
        }
    }

    private void displayError(Exception e) {
        this.clear();
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.model.preview.common", e.getMessage(), (Throwable)e));
        Status status = new Status(4, "org.eclipse.emf.ecp.view.model.preview.common", "Rendering failed. Please re-check your model.", (Throwable)e);
        ErrorViewPart part = new ErrorViewPart((IStatus)status);
        part.createPartControl(this.parent);
    }

    public void removeAdapter() {
        if (this.view == null || this.adapter == null) {
            return;
        }
        for (Adapter a : this.view.eAdapters()) {
            if (a != this.adapter) continue;
            this.view.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
            return;
        }
    }

    public void clear() {
        if (this.render != null) {
            this.render.dispose();
        }
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
        if (this.parent.isDisposed()) {
            return;
        }
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.clearViewDiagnostics(this.view);
    }

    private void clearViewDiagnostics(VView view) {
        if (view == null) {
            return;
        }
        TreeIterator eAllContents = view.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(next)) continue;
            ((VControl)VControl.class.cast(next)).setDiagnostic(null);
            next.eClass();
        }
    }

    public void removeView() {
        this.view = null;
        this.removeAdapter();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        parent.setBackgroundMode(2);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        return composite;
    }

    public boolean isUpdateAutomatic() {
        return this.updateAutomatic;
    }

    public void setUpdateAutomatic(boolean canAutomaticallyRender) {
        this.updateAutomatic = canAutomaticallyRender;
        if (this.updateAutomatic && this.view != null) {
            this.internalRender(this.view);
            this.parent.layout();
        }
    }

    public void cleanSampleData() {
        this.dummyData = null;
    }

    public EObject getSampleData() {
        return this.dummyData;
    }
}

