/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.indexdmr.model.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexdmrPackage;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.ViewValidator;

public class IndexdmrValidator
extends EObjectValidator {
    public static final IndexdmrValidator INSTANCE = new IndexdmrValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecp.view.spi.indexdmr.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ViewValidator viewValidator = ViewValidator.INSTANCE;

    protected EPackage getEPackage() {
        return VIndexdmrPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateIndexDomainModelReference((VIndexDomainModelReference)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateIndexDomainModelReference(VIndexDomainModelReference indexDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)indexDomainModelReference, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)indexDomainModelReference, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)indexDomainModelReference, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateIndexDomainModelReference_resolveable(indexDomainModelReference, diagnostics, context);
        }
        return result;
    }

    protected boolean validate_MultiplicityConforms(EObject eObject, EStructuralFeature eStructuralFeature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eStructuralFeature == VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEFeature()) {
            return true;
        }
        return super.validate_MultiplicityConforms(eObject, eStructuralFeature, diagnostics, context);
    }

    public boolean validateIndexDomainModelReference_resolveable(VIndexDomainModelReference indexDomainModelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass rootEClass = null;
        if (indexDomainModelReference.getDomainModelEFeature() != null) {
            if (!ViewValidator.INSTANCE.validateFeaturePathDomainModelReference_resolveable((VFeaturePathDomainModelReference)indexDomainModelReference, diagnostics, context)) {
                return false;
            }
            EStructuralFeature feature = indexDomainModelReference.getDomainModelEFeature();
            if (!EReference.class.isInstance(feature) || !feature.isMany()) {
                if (diagnostics != null) {
                    this.addValidationToControl(indexDomainModelReference, diagnostics, "Domain model reference does not end at a multi reference.");
                    diagnostics.add(this.createDiagnostic(4, 0, "Domain model reference does not end at a multi reference.", (EObject)indexDomainModelReference, (EStructuralFeature)VViewPackage.eINSTANCE.getFeaturePathDomainModelReference_DomainModelEFeature()));
                }
                return false;
            }
            rootEClass = ((EReference)EReference.class.cast(feature)).getEReferenceType();
        } else if (indexDomainModelReference.getPrefixDMR() == null) {
            if (diagnostics != null) {
                this.addValidationToControl(indexDomainModelReference, diagnostics, "DomainModelEFeature or PrefixDMR must be set.");
                diagnostics.add(this.createDiagnostic(4, 0, "DomainModelEFeature or PrefixDMR must be set.", (EObject)indexDomainModelReference, (EStructuralFeature)VIndexdmrPackage.eINSTANCE.getIndexDomainModelReference_PrefixDMR()));
            }
            return false;
        }
        if (indexDomainModelReference.getIndex() < 0) {
            if (diagnostics != null) {
                String message = "Index has invalid value: " + indexDomainModelReference.getIndex();
                this.addValidationToControl(indexDomainModelReference, diagnostics, message);
                diagnostics.add(this.createDiagnostic(4, 0, message, (EObject)indexDomainModelReference, (EStructuralFeature)VIndexdmrPackage.eINSTANCE.getIndexDomainModelReference_Index()));
            }
            return false;
        }
        if (indexDomainModelReference.getTargetDMR() == null) {
            if (indexDomainModelReference.eContainer() != null && diagnostics != null) {
                diagnostics.add(this.createDiagnostic(4, 0, "No target DMR set.", indexDomainModelReference.eContainer(), indexDomainModelReference.eContainingFeature()));
            }
            return false;
        }
        if (rootEClass != null) {
            VDomainModelReference targetDMR = indexDomainModelReference.getTargetDMR();
            EValidator validator = EValidator.Registry.INSTANCE.getEValidator(targetDMR.eClass().getEPackage());
            LinkedHashMap<Object, Object> newContext = new LinkedHashMap<Object, Object>(context);
            newContext.put("dmr_resolvement_eclass", rootEClass);
            if (!validator.validate((EObject)targetDMR, diagnostics, newContext)) {
                if (indexDomainModelReference.eContainer() != null && diagnostics != null) {
                    diagnostics.add(this.createDiagnostic(4, 0, "Target DMR not resolveable.", indexDomainModelReference.eContainer(), indexDomainModelReference.eContainingFeature()));
                }
                return false;
            }
        }
        return true;
    }

    private void addValidationToControl(VIndexDomainModelReference indexDomainModelReference, DiagnosticChain diagnostics, String message) {
        if (indexDomainModelReference.eContainer() != null) {
            diagnostics.add(this.createDiagnostic(4, 0, message, indexDomainModelReference.eContainer(), indexDomainModelReference.eContainingFeature()));
        }
    }

    private Diagnostic createDiagnostic(int severity, int code, String message, EObject object, EStructuralFeature feature) {
        return new BasicDiagnostic(severity, DIAGNOSTIC_SOURCE, code, message, new Object[]{object, feature});
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

