/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.controlgrid.renderer;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGrid;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGridCell;
import org.eclipse.emf.emfforms.spi.view.controlgrid.model.VControlGridRow;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ControlGridSWTRenderer
extends AbstractSWTRenderer<VControlGrid> {
    private SWTGridDescription rendererGridDescription;
    private final EMFFormsRendererFactory rendererFactory;

    @Inject
    public ControlGridSWTRenderer(VControlGrid vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory rendererFactory) {
        super((VElement)vElement, viewContext, reportService);
        this.rendererFactory = rendererFactory;
    }

    protected EMFFormsRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
            ((SWTGridCell)this.rendererGridDescription.getGrid().get(0)).setVerticalGrab(false);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getColumn() != 0 || cell.getRow() != 0) {
            throw new IllegalArgumentException(MessageFormat.format("The grid cell {0} cannot be rendered.", cell.toString()));
        }
        Map<VControlGridCell, AbstractSWTRenderer<VElement>> renderers = this.getChildRenderers();
        Map<AbstractSWTRenderer<VElement>, SWTGridDescription> gridDescriptions = this.getGridDescriptions(renderers.values());
        Map<SWTGridDescription, Integer> gridDescriptionToRequiredRendererColumnsMap = this.getRequiredColumnSizesOfRenderers(gridDescriptions);
        int actualSWTColumnCountAvailableForEachRenderer = this.getColumnsPerRenderer(gridDescriptionToRequiredRendererColumnsMap);
        Set<Integer> columnsAsPerControlGrid = this.getColumnCountsFromRows();
        int swtColumnsAsPerControlGrid = this.computeColumnCountSoThatAllRowsCanBeRendered(columnsAsPerControlGrid);
        int layoutColumns = swtColumnsAsPerControlGrid * actualSWTColumnCountAvailableForEachRenderer;
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(layoutColumns).equalWidth(false).applyTo(composite);
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            if (row.getCells().size() == 0) {
                this.renderEmptyColumn(composite, layoutColumns);
                continue;
            }
            int swtColumnsAvailableForRowElement = layoutColumns / row.getCells().size();
            for (VControlGridCell vCell : row.getCells()) {
                if (!renderers.containsKey(vCell)) {
                    this.renderEmptyColumn(composite, swtColumnsAvailableForRowElement);
                    continue;
                }
                AbstractSWTRenderer<VElement> renderer = renderers.get(vCell);
                SWTGridDescription swtGridDescription = gridDescriptions.get(renderer);
                int cellsWithoutHorizontalGrab = 0;
                int cellsWithHorizontalGrab = 0;
                for (SWTGridCell swtGridCell : swtGridDescription.getGrid()) {
                    if (!swtGridCell.isHorizontalGrab()) {
                        ++cellsWithoutHorizontalGrab;
                        continue;
                    }
                    ++cellsWithHorizontalGrab;
                }
                int swtColumnsAvailableForGrabingCells = swtColumnsAvailableForRowElement - cellsWithoutHorizontalGrab;
                int spanForSpanningCells = 0;
                int spanForLastSpanningCell = 0;
                if (cellsWithHorizontalGrab > 0) {
                    spanForSpanningCells = swtColumnsAvailableForGrabingCells / cellsWithHorizontalGrab;
                    spanForLastSpanningCell = swtColumnsAvailableForGrabingCells - (cellsWithHorizontalGrab - 1) * spanForSpanningCells;
                }
                this.applyLayout(composite, swtColumnsAvailableForRowElement, swtGridDescription, cellsWithoutHorizontalGrab, cellsWithHorizontalGrab, spanForSpanningCells, spanForLastSpanningCell);
            }
        }
        for (AbstractSWTRenderer<VElement> renderer : renderers.values()) {
            renderer.finalizeRendering(composite);
        }
        composite.layout(true, true);
        return composite;
    }

    private void applyLayout(Composite composite, int swtColumnsAvailableForRowElement, SWTGridDescription swtGridDescription, int cellsWithoutHorizontalGrab, int cellsWithHorizontalGrab, int spanForSpanningCells, int spanForLastSpanningCell) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        int withHorizontalGrabLeft = cellsWithHorizontalGrab;
        int withoutHorizontalGrabLeft = cellsWithoutHorizontalGrab;
        for (SWTGridCell swtGridCell : swtGridDescription.getGrid()) {
            Control control = ((AbstractSWTRenderer)swtGridCell.getRenderer()).render(swtGridCell, composite);
            if (swtGridCell.isHorizontalGrab()) {
                int hSpan = withHorizontalGrabLeft == 1 ? spanForLastSpanningCell : spanForSpanningCells;
                --withHorizontalGrabLeft;
                GridDataFactory.fillDefaults().span(hSpan, 1).grab(true, false).align(4, 0x1000000).applyTo(control);
                continue;
            }
            if (cellsWithHorizontalGrab == 0 && withoutHorizontalGrabLeft == 1) {
                --withoutHorizontalGrabLeft;
                int hSpan = swtColumnsAvailableForRowElement - cellsWithoutHorizontalGrab + 1;
                GridDataFactory.fillDefaults().span(hSpan, 1).grab(true, false).align(4, 0x1000000).applyTo(control);
                continue;
            }
            --withoutHorizontalGrabLeft;
            GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().span(1, 1).grab(false, false).align(1, 0x1000000);
            if (swtGridDescription.getColumns() == 3 && swtGridCell.getColumn() == 1 || swtGridDescription.getColumns() == 2 && swtGridCell.getColumn() == 0) {
                gridDataFactory = gridDataFactory.hint(16, -1);
            }
            gridDataFactory.applyTo(control);
        }
    }

    private void renderEmptyColumn(Composite composite, int swtColumnsAvailableForRowElement) {
        Label label = new Label(composite, 0);
        GridDataFactory.fillDefaults().span(swtColumnsAvailableForRowElement, 1).grab(false, false).applyTo((Control)label);
    }

    private int computeColumnCountSoThatAllRowsCanBeRendered(Set<Integer> columnsAsPerControlGrid) {
        int swtColumnsAsPerControlGrid = 1;
        for (Integer integer : columnsAsPerControlGrid) {
            if (integer == 0) continue;
            swtColumnsAsPerControlGrid = ControlGridSWTRenderer.lcm(swtColumnsAsPerControlGrid, integer);
        }
        return swtColumnsAsPerControlGrid;
    }

    private Set<Integer> getColumnCountsFromRows() {
        LinkedHashSet<Integer> columnsAsPerControlGrid = new LinkedHashSet<Integer>();
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            columnsAsPerControlGrid.add(row.getCells().size());
        }
        return columnsAsPerControlGrid;
    }

    private int getColumnsPerRenderer(Map<SWTGridDescription, Integer> requiredColumnSizesOfRenderers) {
        int columnsPerRenderer = 1;
        for (Integer integer : requiredColumnSizesOfRenderers.values()) {
            columnsPerRenderer = ControlGridSWTRenderer.lcm(columnsPerRenderer, integer);
        }
        return columnsPerRenderer;
    }

    private Map<SWTGridDescription, Integer> getRequiredColumnSizesOfRenderers(Map<AbstractSWTRenderer<VElement>, SWTGridDescription> gridDescriptions) {
        LinkedHashMap<SWTGridDescription, Integer> requiredColumnSizesOfRenderers = new LinkedHashMap<SWTGridDescription, Integer>();
        for (SWTGridDescription description : gridDescriptions.values()) {
            requiredColumnSizesOfRenderers.put(description, description.getColumns());
        }
        return requiredColumnSizesOfRenderers;
    }

    private Map<VControlGridCell, AbstractSWTRenderer<VElement>> getChildRenderers() {
        LinkedHashMap<VControlGridCell, AbstractSWTRenderer<VElement>> renderers = new LinkedHashMap<VControlGridCell, AbstractSWTRenderer<VElement>>();
        for (VControlGridRow row : ((VControlGrid)this.getVElement()).getRows()) {
            for (VControlGridCell cell : row.getCells()) {
                VControl control = cell.getControl();
                if (control == null) continue;
                try {
                    AbstractSWTRenderer renderer = this.getRendererFactory().getRendererInstance((VElement)control, this.getViewModelContext());
                    renderers.put(cell, (AbstractSWTRenderer<VElement>)renderer);
                }
                catch (EMFFormsNoRendererException ex) {
                    this.getReportService().report(new AbstractReport((Throwable)ex));
                }
            }
        }
        return renderers;
    }

    private Map<AbstractSWTRenderer<VElement>, SWTGridDescription> getGridDescriptions(Collection<AbstractSWTRenderer<VElement>> renderers) {
        LinkedHashMap<AbstractSWTRenderer<VElement>, SWTGridDescription> gridDescriptions = new LinkedHashMap<AbstractSWTRenderer<VElement>, SWTGridDescription>();
        for (AbstractSWTRenderer<VElement> renderer : renderers) {
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            gridDescriptions.put(renderer, gridDescription);
        }
        return gridDescriptions;
    }

    protected void dispose() {
        super.dispose();
    }

    private static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return ControlGridSWTRenderer.gcd(b, a % b);
    }

    private static int lcm(int a, int b) {
        return Math.abs(a * b) / ControlGridSWTRenderer.gcd(a, b);
    }
}

