/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.localization.EMFFormsLocalizationService;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="localizationService")
public class EMFFormsLocalizationServiceImpl
implements EMFFormsLocalizationService {
    private EMFFormsLocaleProvider localeProvider;
    private BundleLocalization bundleLocalization;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setEMFFormsLocaleProvider(EMFFormsLocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetEMFFormsLocaleProvider(EMFFormsLocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference
    protected void setBundleLocalization(BundleLocalization bundleLocalization) {
        this.bundleLocalization = bundleLocalization;
    }

    @Reference
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public String getString(Class<?> clazz, String key) {
        return this.getString(FrameworkUtil.getBundle(clazz), key);
    }

    @Override
    public String getString(Bundle bundle, String key) {
        return this.getString(bundle, this.getLocale(), key);
    }

    private String getLocale() {
        if (this.localeProvider == null) {
            return null;
        }
        Locale result = this.localeProvider.getLocale();
        return result.getLanguage();
    }

    private String getString(Bundle bundle, String localeLanguage, String key) {
        ResourceBundle resourceBundle = this.bundleLocalization.getLocalization(bundle, localeLanguage);
        if (resourceBundle == null) {
            this.reportService.report(new AbstractReport(String.format("No ResourceBundle found for Language '%1$s' in Bundle %2$s with Version %3$s.", localeLanguage, bundle.getSymbolicName(), bundle.getVersion().toString())));
            return key;
        }
        if (!resourceBundle.containsKey(key)) {
            this.reportService.report(new AbstractReport(String.format("The ResourceBundle for Language '%1$s' in Bundle %2$s with Version %3$s doesn't contain the key '%4$s'.", localeLanguage, bundle.getSymbolicName(), bundle.getVersion().toString(), key)));
            return key;
        }
        return resourceBundle.getString(key);
    }

    @Override
    public boolean hasKey(Bundle bundle, String key) {
        return this.hasKey(bundle, this.getLocale(), key);
    }

    @Override
    public boolean hasKey(Class<?> clazz, String key) {
        return this.hasKey(FrameworkUtil.getBundle(clazz), key);
    }

    private boolean hasKey(Bundle bundle, String localeLanguage, String key) {
        ResourceBundle resourceBundle = this.bundleLocalization.getLocalization(bundle, localeLanguage);
        if (resourceBundle == null) {
            this.reportService.report(new AbstractReport(String.format("No ResourceBundle found for Language '%1$s' in Bundle %2$s with Version %3$s.", localeLanguage, bundle.getSymbolicName(), bundle.getVersion().toString())));
            return false;
        }
        return resourceBundle.containsKey(key);
    }
}

