/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.converter;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.locale.EMFFormsLocaleProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="EMFFormsSpreadsheetMultiAttributeConverter")
public class EMFFormsSpreadsheetMultiAttributeConverter
implements EMFFormsSpreadsheetValueConverter {
    private static final String SEPARATOR = " ";
    private EMFFormsDatabindingEMF databinding;
    private ReportService reportService;
    private EMFFormsLocaleProvider localeProvider;

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setDatabinding(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected void setEMFFormsLocaleProvider(EMFFormsLocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public double isApplicable(EObject domainObject, VDomainModelReference dmr) {
        EStructuralFeature feature = EMFFormsSpreadsheetValueConverterHelper.getFeature(domainObject, dmr, this.databinding, this.reportService);
        if (feature == null) {
            return Double.NaN;
        }
        if (!EAttribute.class.isInstance(feature)) {
            return Double.NaN;
        }
        if (!feature.isMany()) {
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public void setCellValue(Cell cell, Object fromObject, EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) throws EMFFormsConverterException {
        EDataType eDataType = ((EAttribute)EAttribute.class.cast(eStructuralFeature)).getEAttributeType();
        EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
        StringBuilder result = new StringBuilder();
        for (Object value : (List)fromObject) {
            if (result.length() != 0) {
                result.append(SEPARATOR);
            }
            result.append(eFactory.convertToString(eDataType, value));
        }
        String valueString = result.toString();
        if (this.isDecimalNumber(eDataType.getInstanceClass())) {
            valueString = valueString.replace('.', DecimalFormatSymbols.getInstance(this.localeProvider.getLocale()).getDecimalSeparator());
        }
        cell.setCellValue(valueString);
        cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Text"));
    }

    private boolean isDecimalNumber(Class<?> clazz) {
        return Double.TYPE == clazz || Double.class.isAssignableFrom(clazz) || Float.TYPE == clazz || Float.class.isAssignableFrom(clazz) || BigDecimal.class.isAssignableFrom(clazz);
    }

    @Override
    public Object getCellValue(Cell cell, EStructuralFeature eStructuralFeature) throws EMFFormsConverterException {
        String string;
        try {
            string = cell.getStringCellValue();
        }
        catch (IllegalStateException e) {
            throw new EMFFormsConverterException(String.format("Cell value of column %1$s in row %2$s on sheet %3$s must be a string.", cell.getColumnIndex() + 1, cell.getRowIndex() + 1, cell.getSheet().getSheetName()), e);
        }
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        EDataType eDataType = eAttribute.getEAttributeType();
        if (this.isDecimalNumber(eDataType.getInstanceClass())) {
            string = string.replace(DecimalFormatSymbols.getInstance(this.localeProvider.getLocale()).getDecimalSeparator(), '.');
        }
        ArrayList<Object> result = new ArrayList<Object>();
        EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
        String[] stringArray = string.split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            try {
                result.add(eFactory.createFromString(eDataType, element));
            }
            catch (RuntimeException runtimeException) {
                throw new EMFFormsConverterException(MessageFormat.format("The cell value {0} could not converted to a model value.", string));
            }
            ++n2;
        }
        return result;
    }
}

