/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.treemasterdetail.decorator.validation.ecp;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.common.spi.cachetree.AbstractCachedTree;
import org.eclipse.emf.ecp.common.spi.cachetree.CachedTreeNode;
import org.eclipse.emf.ecp.common.spi.cachetree.IExcludedObjectsCallback;

public class DiagnosticCache
extends AbstractCachedTree<Diagnostic> {
    public DiagnosticCache() {
        super(new IExcludedObjectsCallback(){

            public boolean isExcluded(Object object) {
                return false;
            }
        });
    }

    public Diagnostic getDefaultValue() {
        return Diagnostic.OK_INSTANCE;
    }

    protected CachedTreeNode<Diagnostic> createdCachedTreeNode(Diagnostic value) {
        return new DiagnosticTreeNode(value);
    }

    private class DiagnosticTreeNode
    extends CachedTreeNode<Diagnostic> {
        private final Set<Diagnostic> diagnosticSet;

        DiagnosticTreeNode(Diagnostic initialValue) {
            super((Object)initialValue);
            this.diagnosticSet = new TreeSet<Diagnostic>(new Comparator<Diagnostic>(){

                @Override
                public int compare(Diagnostic o1, Diagnostic o2) {
                    if (o1.getSeverity() == o2.getSeverity()) {
                        if (o1 == o2) {
                            return 0;
                        }
                        return 1;
                    }
                    return -1 * ((Integer)Integer.class.cast(o1.getSeverity())).compareTo(o2.getSeverity());
                }
            });
        }

        public void putIntoCache(Object key, Diagnostic value) {
            boolean updateRequired = true;
            if (this.getCache().containsKey(key)) {
                Diagnostic diagnostic = (Diagnostic)this.getCache().get(key);
                if (diagnostic.getSeverity() == value.getSeverity()) {
                    updateRequired = false;
                }
                this.diagnosticSet.remove(diagnostic);
            }
            this.getCache().put(key, value);
            this.diagnosticSet.add(value);
            if (updateRequired) {
                this.update();
            }
        }

        public void update() {
            Iterator<Diagnostic> iterator = this.diagnosticSet.iterator();
            if (iterator.hasNext()) {
                Diagnostic mostSevereDiagnostic = iterator.next();
                this.setChildValue(mostSevereDiagnostic);
            } else {
                this.setChildValue(DiagnosticCache.this.getDefaultValue());
            }
        }

        public Diagnostic getDisplayValue() {
            if (this.getChildValue() == null) {
                return (Diagnostic)this.getOwnValue();
            }
            return ((Diagnostic)this.getOwnValue()).getSeverity() > ((Diagnostic)this.getChildValue()).getSeverity() ? (Diagnostic)this.getOwnValue() : (Diagnostic)this.getChildValue();
        }
    }
}

