/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="removeSuperType", label="Remove Super Type", description="In the metamodel, a super type is removed from a class. In the model, the values of the features inherited from that super type (including its super types) are deleted.")
public class RemoveSuperType
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class from which the super type is removed")
    public EClass eClass;
    @EdaptParameter(description="The super type to be removed")
    public EClass superType;

    @EdaptConstraint(restricts="superType", description="The super type to be removed actually has to be a super type of the class")
    public boolean checkSuperType(EClass superType) {
        return this.eClass.getESuperTypes().contains((Object)superType);
    }

    @Override
    public void initialize(Metamodel metamodel) {
        if (!this.eClass.getESuperTypes().isEmpty()) {
            this.superType = (EClass)this.eClass.getESuperTypes().get(0);
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        this.eClass.getESuperTypes().remove((Object)this.superType);
        for (Instance instance : model.getAllInstances(this.eClass)) {
            for (EStructuralFeature feature : this.superType.getEAllStructuralFeatures()) {
                this.deleteFeatureValue(instance, feature);
            }
        }
    }
}

