/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.rulerepository.tooling.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.rulerepository.tooling.wizard.EMFFormsNewRuleRepositoryWizardPage;
import org.eclipse.emfforms.internal.rulerepository.tooling.wizard.Messages;
import org.eclipse.emfforms.spi.rulerepository.model.VRuleRepository;
import org.eclipse.emfforms.spi.rulerepository.model.VRulerepositoryFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class EMFFormsRuleRepositoryWizard
extends Wizard
implements INewWizard {
    private ISelection selection;
    private Optional<EMFFormsNewRuleRepositoryWizardPage> newPage = Optional.empty();

    public EMFFormsRuleRepositoryWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.newPage = Optional.of((Object)((Object)new EMFFormsNewRuleRepositoryWizardPage(this.selection)));
        this.addPage((IWizardPage)this.newPage.get());
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.newPage.isPresent() && page == this.newPage.get()) {
            return null;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public boolean performFinish() {
        return this.performFinishNewPage();
    }

    private boolean performFinishNewPage() {
        final String containerName = ((EMFFormsNewRuleRepositoryWizardPage)((Object)this.newPage.get())).getContainerName();
        final String fileName = ((EMFFormsNewRuleRepositoryWizardPage)((Object)this.newPage.get())).getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        EMFFormsRuleRepositoryWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EMFFormsRuleRepositoryWizard_errorTitle, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.EMFFormsRuleRepositoryWizard_creatingTask) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.format("Container \"%s\" does not exist.", containerName));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            VRuleRepository ruleRepository = VRulerepositoryFactory.eINSTANCE.createRuleRepository();
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource ruleRepositoryResource = rs.createResource(URI.createURI((String)file.getLocationURI().toString()));
            ruleRepositoryResource.getContents().add((Object)ruleRepository);
            ruleRepositoryResource.save(null);
            container.refreshLocal(1, monitor);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            monitor.done();
            return;
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.EMFFormsRuleRepositoryWizard_editingTask);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)EMFFormsRuleRepositoryWizard.this.getShell(), (String)"Error", (String)e.getMessage());
                    monitor.done();
                    return;
                }
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.emfforms.rulerepository.tooling", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

