/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.ide.internal.migration.Messages;
import org.eclipse.emf.ecp.ide.internal.migration.Resources;
import org.eclipse.emf.ecp.ide.internal.migration.ViewMigrationDialog;
import org.eclipse.emf.ecp.ide.internal.migration.ViewMigrationException;
import org.eclipse.emf.ecp.ide.internal.migration.ViewMigrationHandler;
import org.eclipse.emf.ecp.ide.internal.migration.ViewMigrationResultDialog;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenViewMigrationDialog
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel;
        Shell shell = Display.getCurrent().getActiveShell();
        final ViewMigrationDialog dialog = new ViewMigrationDialog(shell);
        if (dialog.open() == 0 && (sel = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getSelectionService().getSelection()) instanceof IStructuredSelection) {
            Job job = new Job(Messages.OpenViewMigrationDialog_JobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    subMonitor.setTaskName(Messages.OpenViewMigrationDialog_Find);
                    Set<IFile> viewModelFiles = Resources.findAllViewFilesInWorkspace(subMonitor.split(20));
                    subMonitor.setWorkRemaining(80);
                    subMonitor.setTaskName(Messages.OpenViewMigrationDialog_Migrate);
                    try {
                        Map<String, Optional<Diagnostic>> diagnostics = new ViewMigrationHandler(dialog.getOldNamespaceFragment(), dialog.getNewNamespaceFragment()).execute(viewModelFiles, subMonitor.split(80));
                        OpenViewMigrationDialog.this.showResultDialog(diagnostics);
                    }
                    catch (ViewMigrationException ex) {
                        return new Status(4, "org.eclipse.emf.ecp.ide.migration", 4, Messages.OpenUpdateNSDialog_ErrorTitle, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    private void showResultDialog(final Map<String, Optional<Diagnostic>> diagnostics) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ViewMigrationResultDialog dialog = new ViewMigrationResultDialog(Display.getCurrent().getActiveShell(), diagnostics);
                dialog.open();
            }
        });
    }
}

