/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.section.swt;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecp.view.internal.section.ui.swt.Activator;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.reporting.AbstractReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.section.model.VSection;
import org.eclipse.emf.ecp.view.spi.swt.AbstractAdditionalSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSectionSWTRenderer
extends AbstractSWTRenderer<VSection> {
    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (cell.getRenderer() == this) {
            switch (cell.getColumn()) {
                case 0: {
                    return this.createFirstColumn(parent);
                }
                case 1: {
                    if (((VSection)this.getVElement()).getChildren().size() < 3) {
                        return this.renderEmpty(parent);
                    }
                    return this.renderChild(parent, (VContainedElement)((VSection)this.getVElement()).getChildren().get(0));
                }
                case 2: {
                    if (((VSection)this.getVElement()).getChildren().size() < 2) {
                        return this.renderEmpty(parent);
                    }
                    return this.renderChild(parent, (VContainedElement)((VSection)this.getVElement()).getChildren().get(((VSection)this.getVElement()).getChildren().size() - 2));
                }
                case 3: {
                    return this.renderChild(parent, (VContainedElement)((VSection)this.getVElement()).getChildren().get(((VSection)this.getVElement()).getChildren().size() - 1));
                }
            }
            throw new IllegalArgumentException("");
        }
        return ((AbstractSWTRenderer)cell.getRenderer()).render(cell, parent);
    }

    protected abstract Control createFirstColumn(Composite var1);

    private Control renderEmpty(Composite parent) {
        return new Label(parent, 0);
    }

    private Control renderChild(Composite parent, VContainedElement child) throws NoRendererFoundException {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        LinkedHashMap elementRendererMap = new LinkedHashMap();
        SWTGridDescription maximalGridDescription = null;
        LinkedHashMap<VContainedElement, SWTGridDescription> rowGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        LinkedHashMap<VContainedElement, SWTGridDescription> controlGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        if (VControl.class.isInstance(child) && (((VControl)VControl.class.cast(child)).getDomainModelReference() == null || !((VControl)VControl.class.cast(child)).getDomainModelReference().getIterator().hasNext())) {
            return columnComposite;
        }
        AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer((VElement)child, this.getViewModelContext());
        if (renderer == null) {
            return columnComposite;
        }
        Collection additionalRenderers = this.getSWTRendererFactory().getAdditionalRenderer((VElement)child, this.getViewModelContext());
        SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
        controlGridDescription.put(child, gridDescription);
        for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
            gridDescription = additionalRenderer.getGridDescription(gridDescription);
        }
        rowGridDescription.put(child, gridDescription);
        maximalGridDescription = gridDescription;
        LinkedHashSet<AbstractSWTRenderer> allRenderer = new LinkedHashSet<AbstractSWTRenderer>();
        allRenderer.add(renderer);
        allRenderer.addAll(additionalRenderers);
        elementRendererMap.put(child, allRenderer);
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(this.getLayout(maximalGridDescription.getColumns(), false));
        try {
            if (VControl.class.isInstance(child) && (((VControl)VControl.class.cast(child)).getDomainModelReference() == null || !((VControl)VControl.class.cast(child)).getDomainModelReference().getIterator().hasNext())) {
                return columnComposite;
            }
            SWTGridDescription gridDescription2 = (SWTGridDescription)rowGridDescription.get(child);
            if (gridDescription2 == null) {
                return columnComposite;
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                Control control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                if (control == null) continue;
                this.setLayoutDataForControl(childGridCell, (SWTGridDescription)controlGridDescription.get(child), gridDescription2, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription2.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        catch (NoPropertyDescriptorFoundExeption ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
            return columnComposite;
        }
        return columnComposite;
    }

    private Layout getLayout(int numControls, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numControls, (boolean)equalWidth);
    }

    protected void adjustLayoutData(boolean collapsed) {
        boolean visible = collapsed;
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            GridData gridData;
            Object layoutData = ((Control)this.getControls().get(gridCell)).getLayoutData();
            if (GridData.class.isInstance(layoutData) && (gridData = (GridData)layoutData) != null) {
                gridData.exclude = !visible;
            }
            ((Control)this.getControls().get(gridCell)).setVisible(visible);
        }
    }
}

