/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

public class EMFDeleteServiceImpl
implements DeleteService {
    private EditingDomain editingDomain;

    public void instantiate(ViewModelContext context) {
        this.editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)context.getDomainModel());
    }

    public void dispose() {
    }

    public int getPriority() {
        return 1;
    }

    @Override
    public void deleteElements(final Collection<Object> toDelete) {
        if (toDelete == null || toDelete.isEmpty()) {
            return;
        }
        if (this.editingDomain == null) {
            this.deleteWithoutEditingDomain(toDelete);
            return;
        }
        Command deleteCommand = DeleteCommand.create((EditingDomain)this.editingDomain, toDelete);
        if (deleteCommand.canExecute()) {
            if (this.editingDomain.getCommandStack() == null) {
                deleteCommand.execute();
            } else {
                this.editingDomain.getCommandStack().execute(deleteCommand);
            }
            return;
        }
        ChangeCommand changeCommand = new ChangeCommand((Notifier)this.editingDomain.getResourceSet()){

            protected void doExecute() {
                EMFDeleteServiceImpl.this.deleteWithoutEditingDomain(toDelete);
            }
        };
        if (changeCommand.canExecute()) {
            if (this.editingDomain.getCommandStack() == null) {
                changeCommand.execute();
            } else {
                this.editingDomain.getCommandStack().execute((Command)changeCommand);
            }
            return;
        }
        throw new IllegalStateException("Delete was not successful.");
    }

    private void deleteWithoutEditingDomain(Collection<Object> toDelete) {
        for (Object object : toDelete) {
            Object unwrap = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (!EObject.class.isInstance(unwrap)) continue;
            EcoreUtil.delete((EObject)((EObject)EObject.class.cast(unwrap)), (boolean)true);
        }
    }

    @Override
    public void deleteElement(Object toDelete) {
        if (toDelete == null) {
            return;
        }
        this.deleteElements(Collections.singleton(toDelete));
    }
}

