/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.renderer.table;

import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexdmrFactory;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.internal.spreadsheet.core.renderer.EMFFormsSpreadsheetControlRenderer;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsExportTableParent;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsIdProvider;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetFormatDescriptionProvider;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterRegistry;

public class EMFFormsSpreadsheetTableControlRenderer
extends EMFFormsAbstractSpreadsheetRenderer<VTableControl> {
    private final EMFFormsDatabindingEMF emfformsDatabinding;
    private final EMFFormsLabelProvider emfformsLabelProvider;
    private final ReportService reportService;
    private final EMFFormsSpreadsheetRendererFactory rendererFactory;
    private final VTViewTemplateProvider vtViewTemplateProvider;
    private final EMFFormsIdProvider emfFormsIdProvider;
    private final EMFFormsSpreadsheetValueConverterRegistry converterRegistry;
    private final EMFFormsSpreadsheetFormatDescriptionProvider formatDescriptionProvider;

    public EMFFormsSpreadsheetTableControlRenderer(EMFFormsDatabindingEMF emfformsDatabinding, EMFFormsLabelProvider emfformsLabelProvider, ReportService reportService, EMFFormsSpreadsheetRendererFactory rendererFactory, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsIdProvider emfFormsIdProvider, EMFFormsSpreadsheetValueConverterRegistry converterRegistry, EMFFormsSpreadsheetFormatDescriptionProvider formatDescriptionProvider) {
        this.emfformsDatabinding = emfformsDatabinding;
        this.emfformsLabelProvider = emfformsLabelProvider;
        this.reportService = reportService;
        this.rendererFactory = rendererFactory;
        this.vtViewTemplateProvider = vtViewTemplateProvider;
        this.emfFormsIdProvider = emfFormsIdProvider;
        this.converterRegistry = converterRegistry;
        this.formatDescriptionProvider = formatDescriptionProvider;
    }

    public int render(Workbook workbook, VTableControl vElement, ViewModelContext viewModelContext, EMFFormsSpreadsheetRenderTarget eMFFormsSpreadsheetRenderTarget) {
        EMFFormsSpreadsheetControlRenderer controlRenderer = new EMFFormsSpreadsheetControlRenderer(this.emfformsDatabinding, this.emfformsLabelProvider, this.reportService, this.vtViewTemplateProvider, this.emfFormsIdProvider, this.converterRegistry, this.formatDescriptionProvider);
        int numColumns = 0;
        try {
            EMFFormsExportTableParent exportTableParent = (EMFFormsExportTableParent)viewModelContext.getContextValue("excelExportParent");
            VDomainModelReference dmrToResolve = (VDomainModelReference)EcoreUtil.copy((EObject)vElement.getDomainModelReference());
            if (exportTableParent != null) {
                VIndexDomainModelReference indexDMR = exportTableParent.getIndexDMRToExtend();
                indexDMR.setTargetDMR(dmrToResolve);
                dmrToResolve = exportTableParent.getIndexDMRToResolve();
            }
            IObservableList observableList = this.emfformsDatabinding.getObservableList(dmrToResolve, viewModelContext.getDomainModel());
            VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)vElement.getDomainModelReference();
            int i = 0;
            while (i < 3) {
                EObject tableEntry;
                VView viewModel;
                EMFFormsExportTableParent tableParent;
                String prefixName = (String)this.emfformsLabelProvider.getDisplayName(tableDomainModelReference.getDomainModelReference()).getValue();
                if (prefixName == null || prefixName.length() == 0) {
                    try {
                        prefixName = this.emfformsDatabinding.getValueProperty(tableDomainModelReference.getDomainModelReference(), viewModelContext.getDomainModel()).getStructuralFeature().getName();
                    }
                    catch (DatabindingFailedException ex) {
                        this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
                    }
                }
                VIndexDomainModelReference indexDMR = VIndexdmrFactory.eINSTANCE.createIndexDomainModelReference();
                indexDMR.setPrefixDMR((VDomainModelReference)EcoreUtil.copy((EObject)tableDomainModelReference.getDomainModelReference()));
                indexDMR.setIndex(i);
                if (exportTableParent == null) {
                    tableParent = new EMFFormsExportTableParent(indexDMR, indexDMR, prefixName);
                } else {
                    VIndexDomainModelReference wrapper = exportTableParent.getIndexDMRToExtend();
                    wrapper.setTargetDMR((VDomainModelReference)indexDMR);
                    tableParent = new EMFFormsExportTableParent(indexDMR, exportTableParent.getIndexDMRToResolve(), String.valueOf(exportTableParent.getLabelPrefix()) + "_" + prefixName);
                }
                for (VDomainModelReference domainModelReference : tableDomainModelReference.getColumnDomainModelReferences()) {
                    VControl vControl = VViewFactory.eINSTANCE.createControl();
                    vControl.setDomainModelReference((VDomainModelReference)EcoreUtil.copy((EObject)domainModelReference));
                    ViewModelContext subViewModelContext = viewModelContext.getChildContext(viewModelContext.getDomainModel(), (VElement)vElement, (VView)viewModelContext.getViewModel(), new ViewModelService[0]);
                    subViewModelContext.putContextValue("excelExportParent", (Object)tableParent);
                    numColumns += controlRenderer.render(workbook, vControl, subViewModelContext, new EMFFormsSpreadsheetRenderTarget(eMFFormsSpreadsheetRenderTarget.getSheetName(), eMFFormsSpreadsheetRenderTarget.getRow(), eMFFormsSpreadsheetRenderTarget.getColumn() + numColumns));
                }
                if (vElement.getDetailEditing() != DetailEditing.NONE && (viewModel = this.getView(vElement, tableEntry = this.getTableEntry(observableList, i), viewModelContext)) != null) {
                    ViewModelContext subViewModelContext = viewModelContext.getChildContext(viewModelContext.getDomainModel(), (VElement)vElement, viewModel, new ViewModelService[0]);
                    subViewModelContext.putContextValue("excelExportParent", (Object)tableParent);
                    try {
                        EMFFormsAbstractSpreadsheetRenderer renderer = this.rendererFactory.getRendererInstance((VElement)viewModel, subViewModelContext);
                        int renderedColumns = renderer.render(workbook, (VElement)viewModel, subViewModelContext, new EMFFormsSpreadsheetRenderTarget(eMFFormsSpreadsheetRenderTarget.getSheetName(), eMFFormsSpreadsheetRenderTarget.getRow(), eMFFormsSpreadsheetRenderTarget.getColumn() + numColumns));
                        numColumns += renderedColumns;
                    }
                    catch (EMFFormsNoRendererException ex) {
                        this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
                    }
                }
                ++i;
            }
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        catch (NoLabelFoundException ex) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
        }
        return numColumns;
    }

    private EObject getTableEntry(IObservableList observableList, int currentColumn) {
        EObject tableEntry = observableList.size() > currentColumn ? (EObject)observableList.get(currentColumn) : EcoreUtil.create((EClass)((EReference)EReference.class.cast(observableList.getElementType())).getEReferenceType());
        return tableEntry;
    }

    private VView getView(VTableControl tableControl, EObject domainObject, ViewModelContext viewModelContext) throws DatabindingFailedException {
        VView detailView = tableControl.getDetailView();
        if (detailView == null && tableControl.getDetailEditing() != DetailEditing.WITH_DIALOG) {
            VElement viewModel = viewModelContext.getViewModel();
            VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
            detailView = ViewProviderHelper.getView((EObject)domainObject, (VViewModelProperties)properties);
        }
        return detailView;
    }
}

