/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.util.e4.fx;

import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdImpl;

public class ModelElementOpenerFX {
    private static final String partId = "org.eclipse.emf.ecp.application.e4.fx.partdescriptor.editor";
    private static final String MODEL_ELEMENT_ID_PERSIST_KEY = "modelElementId";
    private static final String PROJECT_ID_PERSIST_KEY = "projectId";

    public static void openModelElement(Object modelElement) {
        EPartService partService = ModelElementOpenerFX.getEPartService();
        for (MPart existingPart : partService.getParts()) {
            if (!partId.equals(existingPart.getElementId())) continue;
            if (existingPart.getContext() == null) {
                List projects = ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProjects();
                ESLocalProject project = null;
                String projectId = (String)existingPart.getPersistedState().get(PROJECT_ID_PERSIST_KEY);
                for (ESLocalProject p : projects) {
                    if (!p.getLocalProjectId().getId().equals(projectId)) continue;
                    project = p;
                    break;
                }
                if (project != null) {
                    String modelElementIdString = (String)existingPart.getPersistedState().get(MODEL_ELEMENT_ID_PERSIST_KEY);
                    ModelElementId mEId = ModelFactory.eINSTANCE.createModelElementId();
                    mEId.setId(modelElementIdString);
                    ESModelElementIdImpl modelElementId = new ESModelElementIdImpl(mEId);
                    EObject persistedModelElement = project.getModelElement((Object)modelElementId);
                    if (!modelElement.equals(persistedModelElement)) continue;
                    if (!existingPart.isVisible() || !existingPart.isOnTop()) {
                        partService.showPart(existingPart, EPartService.PartState.ACTIVATE);
                    }
                    return;
                }
            }
            if (existingPart.getContext().get("ecpEditorInput") != modelElement) continue;
            if (!existingPart.isVisible() || !existingPart.isOnTop()) {
                partService.showPart(existingPart, EPartService.PartState.ACTIVATE);
            }
            return;
        }
        MPart part = partService.createPart(partId);
        partService.showPart(part, EPartService.PartState.ACTIVATE);
        part.getContext().set("ecpEditorInput", modelElement);
    }

    private static EPartService getEPartService() {
        MApplication currentApplication = ((IWorkbench)E4Workbench.getServiceContext().get(IWorkbench.class)).getApplication();
        IEclipseContext selectedWindowContext = ((MWindow)currentApplication.getSelectedElement()).getContext();
        return (EPartService)selectedWindowContext.get(EPartService.class);
    }
}

