/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.preview.e3.views;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.ide.editor.view.ViewEditorPart;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.model.internal.preview.Activator;
import org.eclipse.emf.ecp.view.model.internal.preview.Messages;
import org.eclipse.emf.ecp.view.model.preview.common.Preview;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PreviewView
extends ViewPart
implements ISelectionListener {
    private Preview preView;
    private IPartListener2 partListener;
    private Composite form;
    private EContentAdapter adapter;
    private VView view;
    private boolean updateAutomatic;
    private Composite parent;
    private Action automaticToggleButton;
    private Action manualRefreshButton;
    private Color headerBgColor;
    private Font titleFont;
    private Color titleColor;
    private ScrolledComposite scrolledComposite;
    private Composite container;
    private Action loadDataButton;
    private EObject sampleData;
    private Action cleanDataButton;
    private Action exportDataButton;

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.preView.clear();
        this.preView.removeAdapter();
        this.titleColor.dispose();
        this.titleFont.dispose();
        this.headerBgColor.dispose();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.form = new Composite(parent, 2048);
        this.form.setBackground(parent.getDisplay().getSystemColor(1));
        this.form.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Composite headerComposite = new Composite(this.form, 4);
        GridLayout headerLayout = GridLayoutFactory.fillDefaults().create();
        headerComposite.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)headerComposite);
        this.headerBgColor = new Color((Device)parent.getDisplay(), new RGB(220, 240, 247));
        headerComposite.setBackground(this.headerBgColor);
        Composite header = this.getPageHeader(headerComposite);
        ToolBar toolBar = new ToolBar(header, 0x820000);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        toolBar.setLayoutData((Object)formData);
        toolBar.layout();
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.addButtonsToFormToolbar((IToolBarManager)toolBarManager);
        header.layout();
        this.scrolledComposite = new ScrolledComposite(this.form, 768);
        this.scrolledComposite.setShowFocusedControl(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.scrolledComposite);
        this.scrolledComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.scrolledComposite.setBackground(parent.getDisplay().getSystemColor(1));
        this.container = new Composite((Composite)this.scrolledComposite, 4);
        GridLayout containerLayout = GridLayoutFactory.fillDefaults().create();
        containerLayout.marginLeft = 10;
        containerLayout.marginRight = 10;
        this.container.setLayout((Layout)containerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.container);
        this.container.setBackground(this.scrolledComposite.getBackground());
        this.scrolledComposite.setContent((Control)this.container);
        this.container.addPaintListener((PaintListener)new PreviewPaintListener());
        this.container.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Point point = PreviewView.this.container.computeSize(-1, -1);
                PreviewView.this.scrolledComposite.setMinSize(point);
                PreviewView.this.container.layout(true);
                PreviewView.this.scrolledComposite.layout(true);
            }

            public void controlMoved(ControlEvent e) {
                Point point = PreviewView.this.container.computeSize(-1, -1);
                PreviewView.this.scrolledComposite.setMinSize(point);
                PreviewView.this.container.layout(true);
                PreviewView.this.scrolledComposite.layout(true);
            }
        });
        this.preView = new Preview(this.container);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart part = reference.getEditor(false);
            if (page.isPartVisible((IWorkbenchPart)part) && ViewEditorPart.class.isInstance(part)) {
                ViewEditorPart viewPart = (ViewEditorPart)part;
                this.setView(viewPart.getView());
                this.render(this.view);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        this.partListener = new PreviewPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
    }

    private Composite getPageHeader(Composite parent) {
        Composite header = new Composite(parent, 4);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        header.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)header);
        header.setBackground(parent.getBackground());
        Label titleImage = new Label(header, 4);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/preview.png"));
        titleImage.setImage(new Image((Device)parent.getDisplay(), imageDescriptor.getImageData()));
        FormData titleImageData = new FormData();
        int imageOffset = -titleImage.computeSize((int)-1, (int)-1).y / 2;
        titleImageData.top = new FormAttachment(50, imageOffset);
        titleImageData.left = new FormAttachment(0, 10);
        titleImage.setLayoutData((Object)titleImageData);
        Label title = new Label(header, 64);
        title.setText(Messages.PreviewView_EditorTitle);
        this.titleFont = new Font((Device)title.getDisplay(), this.getDefaultFontName(title), 12, 1);
        title.setFont(this.titleFont);
        title.setForeground(this.getTitleColor());
        FormData titleData = new FormData();
        title.setLayoutData((Object)titleData);
        titleData.left = new FormAttachment((Control)titleImage, 5, -1);
        return header;
    }

    private String getDefaultFontName(Label control) {
        return control.getDisplay().getSystemFont().getFontData()[0].getName();
    }

    private Color getTitleColor() {
        if (this.titleColor == null) {
            this.titleColor = new Color((Device)this.form.getDisplay(), new RGB(25, 76, 127));
        }
        return this.titleColor;
    }

    private void addButtonsToFormToolbar(IToolBarManager toolBarManager) {
        this.addSampleDataButtons(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator());
        this.addRefreshButtons(toolBarManager);
        toolBarManager.update(true);
    }

    private void addSampleDataButtons(IToolBarManager toolBarManager) {
        this.loadDataButton = new Action(){

            public void run() {
                super.run();
                PreviewView.this.loadSampleData();
            }
        };
        this.loadDataButton.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/loadData.png")));
        this.loadDataButton.setText(Messages.PreviewView_ImportSampleDataButton);
        this.loadDataButton.setEnabled(true);
        this.exportDataButton = new Action(){

            public void run() {
                super.run();
                PreviewView.this.exportSampleData();
            }
        };
        this.exportDataButton.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/exportData.png")));
        this.exportDataButton.setText(Messages.PreviewView_ExportSampleDataButton);
        this.exportDataButton.setEnabled(true);
        this.cleanDataButton = new Action(){

            public void run() {
                super.run();
                PreviewView.this.sampleData = null;
                PreviewView.this.preView.cleanSampleData();
                PreviewView.this.render();
            }
        };
        this.cleanDataButton.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/cleanData.png")));
        this.cleanDataButton.setText(Messages.PreviewView_ClearSampleDataButton);
        this.cleanDataButton.setEnabled(true);
        toolBarManager.add((IAction)this.cleanDataButton);
        toolBarManager.add((IAction)this.loadDataButton);
        toolBarManager.add((IAction)this.exportDataButton);
    }

    private void addRefreshButtons(IToolBarManager toolBarManager) {
        this.automaticToggleButton = new Action("", 2){

            public void run() {
                super.run();
                PreviewView.this.setUpdateAutomatic(this.isChecked());
                PreviewView.this.manualRefreshButton.setEnabled(!this.isChecked());
            }
        };
        this.automaticToggleButton.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/arrow_rotate_anticlockwise.png")));
        this.automaticToggleButton.setText(Messages.PreviewView_AutomaticRefresh);
        this.automaticToggleButton.setEnabled(true);
        this.automaticToggleButton.setChecked(false);
        this.manualRefreshButton = new Action(){

            public void run() {
                super.run();
                PreviewView.this.render();
            }
        };
        this.manualRefreshButton.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/arrow_refresh.png")));
        this.manualRefreshButton.setText(Messages.PreviewView_ManualRefresh);
        this.manualRefreshButton.setEnabled(true);
        toolBarManager.add((IAction)this.manualRefreshButton);
        toolBarManager.add((IAction)this.automaticToggleButton);
    }

    /*
     * Unable to fully structure code
     */
    protected void exportSampleData() {
        block6: {
            if (this.preView == null) {
                return;
            }
            sampleData = this.preView.getSampleData();
            if (sampleData == null) {
                return;
            }
            dialog = new FileDialog(this.parent.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xmi"});
            result = dialog.open();
            if (result == null) {
                return;
            }
            rs = new ResourceSetImpl();
            resource = rs.createResource(URI.createFileURI((String)result));
            resource.getContents().add((Object)sampleData);
            try {
                resource.save(null);
                break block6;
            }
            catch (IOException e) {
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                stackTrace = sw.toString();
                childStatuses = new ArrayList<Status>();
                var13_10 = stackTrace.split(System.getProperty("line.separator"));
                var12_11 = var13_10.length;
                var11_12 = 0;
                ** while (var11_12 < var12_11)
            }
lbl-1000:
            // 1 sources

            {
                line = var13_10[var11_12];
                childStatuses.add(new Status(4, "org.eclipse.emf.ecp.view.model.preview.e3", line));
                ++var11_12;
                continue;
            }
lbl32:
            // 1 sources

            status = new MultiStatus("org.eclipse.emf.ecp.view.model.preview.e3", 4, (IStatus[])childStatuses.toArray(new Status[0]), e.getLocalizedMessage(), null);
            ErrorDialog.openError((Shell)this.parent.getShell(), (String)Messages.PreviewView_SaveErrorDialogTitle, (String)Messages.PreviewView_SaveErrorDescription, (IStatus)status);
        }
    }

    private void loadSampleData() {
        if (this.view == null || this.view.getRootEClass() == null) {
            return;
        }
        FileDialog dialog = new FileDialog(this.parent.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xmi"});
        String result = dialog.open();
        if (result == null) {
            return;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)}), (CommandStack)new BasicCommandStack(), (ResourceSet)rs);
        rs.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        Resource resource = rs.createResource(URI.createFileURI((String)result));
        try {
            resource.load(null);
        }
        catch (IOException iOException) {}
        if (!resource.getContents().isEmpty()) {
            this.sampleData = (EObject)resource.getContents().get(0);
            if (this.sampleData != null && this.sampleData.eClass() == this.view.getRootEClass()) {
                this.render();
            } else {
                new MessageDialog(this.parent.getShell(), Messages.PreviewView_WrongInputTypeError, null, String.format(Messages.PreviewView_WrongInputTypeErrorDetails, this.sampleData.eClass().getName(), this.view.getRootEClass().getName()), 1, new String[]{Messages.PreviewView_OK}, 0).open();
                this.sampleData = null;
            }
        } else {
            this.sampleData = null;
            new MessageDialog(this.parent.getShell(), Messages.PreviewView_WrongInputFileContentError, null, Messages.PreviewView_WrongInputFileContentErrorDetails, 1, new String[]{Messages.PreviewView_OK}, 0).open();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object firstElement = ss.getFirstElement();
        if (!VView.class.isInstance(firstElement)) {
            return;
        }
        this.setView((VView)firstElement);
        this.render(this.view);
    }

    private void render(VView view) {
        if (this.adapter != null) {
            this.removeAdapters();
        }
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                if (PreviewView.this.form.isDisposed()) {
                    return;
                }
                super.notifyChanged(notification);
                if (notification.isTouch()) {
                    return;
                }
                if (((EStructuralFeature)EStructuralFeature.class.cast(notification.getFeature())).isTransient()) {
                    return;
                }
                Point point = PreviewView.this.container.computeSize(-1, -1);
                PreviewView.this.scrolledComposite.setMinSize(point);
                PreviewView.this.scrolledComposite.layout(true);
            }
        };
        view.eAdapters().add((Object)this.adapter);
        this.preView.registerForViewModelChanges();
        this.preView.render(view, this.sampleData);
        Point point = this.container.computeSize(-1, -1);
        this.scrolledComposite.setMinSize(point);
        this.scrolledComposite.layout(true);
    }

    private void setView(VView view) {
        if (this.view != view) {
            this.removeAdapters();
            this.view = view;
        }
    }

    private void removeAdapters() {
        if (this.view != null && this.adapter != null) {
            for (Adapter a : this.view.eAdapters()) {
                if (!a.equals(this.adapter)) continue;
                this.view.eAdapters().remove((Object)this.adapter);
                this.adapter = null;
                break;
            }
        }
        this.preView.removeAdapter();
    }

    public boolean isUpdateAutomatic() {
        return this.updateAutomatic;
    }

    private void setUpdateAutomatic(boolean updateAutomatic) {
        this.updateAutomatic = updateAutomatic;
        if (this.preView != null) {
            this.preView.setUpdateAutomatic(updateAutomatic);
            Point point = this.container.computeSize(-1, -1);
            this.scrolledComposite.setMinSize(point);
            this.scrolledComposite.layout(true);
        }
    }

    private void render() {
        if (this.preView != null) {
            if (this.view != null) {
                this.render(this.view);
                Point point = this.container.computeSize(-1, -1);
                this.scrolledComposite.setMinSize(point);
                this.scrolledComposite.layout(true);
                this.parent.layout();
            } else {
                this.preView.clear();
            }
        }
    }

    private final class PreviewPaintListener
    implements PaintListener {
        private PreviewPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Point point = PreviewView.this.container.computeSize(-1, -1);
            PreviewView.this.scrolledComposite.setMinSize(point);
            PreviewView.this.container.layout(true);
            PreviewView.this.scrolledComposite.layout(true);
        }
    }

    private final class PreviewPartListener
    implements IPartListener2 {
        private PreviewPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (ViewEditorPart.class.isInstance(partRef.getPart(true))) {
                ViewEditorPart part = (ViewEditorPart)partRef.getPart(true);
                if (part.getView() != PreviewView.this.view) {
                    PreviewView.this.setView(part.getView());
                    PreviewView.this.sampleData = null;
                    PreviewView.this.render(PreviewView.this.view);
                }
                if (PreviewView.this.updateAutomatic) {
                    PreviewView.this.preView.registerForViewModelChanges();
                }
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (PreviewView.class.isInstance(partRef.getPart(true))) {
                PreviewView.this.getSite().getPage().removePartListener((IPartListener2)this);
            }
            if (ViewEditorPart.class.isInstance(partRef.getPart(true))) {
                if (PreviewView.this.updateAutomatic) {
                    PreviewView.this.preView.clear();
                }
                PreviewView.this.preView.removeView();
                PreviewView.this.view = null;
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(true);
            if (ViewEditorPart.class.isInstance(part) || PreviewView.class.isInstance(part)) {
                PreviewView.this.removeAdapters();
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }
    }
}

