/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.spreadsheet.core.error.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emfforms.internal.core.services.label.EMFFormsLabelProviderImpl;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.EMFLocation;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorPackage;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorReport;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SettingToSheetMapping;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.Severity;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SheetLocation;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SpreadsheetImportResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class SpreadsheetImportResultImpl
extends MinimalEObjectImpl.Container
implements SpreadsheetImportResult {
    protected EList<ErrorReport> errorReports;
    protected EList<EObject> importedEObjects;
    protected EList<SettingToSheetMapping> settingToSheetMap;

    protected SpreadsheetImportResultImpl() {
    }

    protected EClass eStaticClass() {
        return ErrorPackage.Literals.SPREADSHEET_IMPORT_RESULT;
    }

    @Override
    public EList<ErrorReport> getErrorReports() {
        if (this.errorReports == null) {
            this.errorReports = new EObjectContainmentEList(ErrorReport.class, (InternalEObject)this, 0);
        }
        return this.errorReports;
    }

    @Override
    public EList<EObject> getImportedEObjects() {
        if (this.importedEObjects == null) {
            this.importedEObjects = new EObjectResolvingEList(EObject.class, (InternalEObject)this, 1);
        }
        return this.importedEObjects;
    }

    @Override
    public EList<SettingToSheetMapping> getSettingToSheetMap() {
        if (this.settingToSheetMap == null) {
            this.settingToSheetMap = new EObjectResolvingEList(SettingToSheetMapping.class, (InternalEObject)this, 2);
        }
        return this.settingToSheetMap;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getErrorReports()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getErrorReports();
            }
            case 1: {
                return this.getImportedEObjects();
            }
            case 2: {
                return this.getSettingToSheetMap();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getErrorReports().clear();
                this.getErrorReports().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getImportedEObjects().clear();
                this.getImportedEObjects().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getSettingToSheetMap().clear();
                this.getSettingToSheetMap().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getErrorReports().clear();
                return;
            }
            case 1: {
                this.getImportedEObjects().clear();
                return;
            }
            case 2: {
                this.getSettingToSheetMap().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.errorReports != null && !this.errorReports.isEmpty();
            }
            case 1: {
                return this.importedEObjects != null && !this.importedEObjects.isEmpty();
            }
            case 2: {
                return this.settingToSheetMap != null && !this.settingToSheetMap.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void reportError(Severity severity, String message) {
        this.reportError(severity, message, null, null);
    }

    @Override
    public void reportError(Severity severity, String message, EMFLocation emfLocation) {
        this.reportError(severity, message, emfLocation, null);
    }

    @Override
    public void reportError(Severity severity, String message, SheetLocation sheetLocation) {
        this.reportError(severity, message, null, sheetLocation);
    }

    @Override
    public void reportError(Severity severity, String message, EMFLocation emfLocation, SheetLocation sheetLocation) {
        ErrorReport report = ErrorFactory.eINSTANCE.createErrorReport();
        report.setSeverity(severity);
        report.setMessage(message);
        report.setEmfLocation(emfLocation);
        report.setSheetLocation(sheetLocation);
        this.getErrorReports().add((Object)report);
    }

    @Override
    public Collection<SheetLocation> getSheetLocations(EStructuralFeature structuralFeature) {
        LinkedHashSet<SheetLocation> result = new LinkedHashSet<SheetLocation>();
        for (SettingToSheetMapping settingToSheetMapping : this.getSettingToSheetMap()) {
            if (structuralFeature != settingToSheetMapping.getSettingLocation().getFeature()) continue;
            result.add((SheetLocation)EcoreUtil.copy((EObject)settingToSheetMapping.getSheetLocation()));
        }
        if (!result.isEmpty()) {
            return result;
        }
        return Collections.singleton(ErrorFactory.eINSTANCE.createInvalidSheetLocation(this.getFeatureName(structuralFeature)));
    }

    @Override
    public SheetLocation getSheetLocation(EObject eObject, EStructuralFeature structuralFeature) {
        SheetLocation possibleResult = null;
        for (SettingToSheetMapping settingToSheetMapping : this.getSettingToSheetMap()) {
            if (structuralFeature != settingToSheetMapping.getSettingLocation().getFeature()) continue;
            if (possibleResult == null) {
                possibleResult = settingToSheetMapping.getSheetLocation();
            }
            if (eObject != settingToSheetMapping.getSettingLocation().getEObject()) continue;
            return (SheetLocation)EcoreUtil.copy((EObject)settingToSheetMapping.getSheetLocation());
        }
        if (possibleResult != null) {
            SheetLocation result = (SheetLocation)EcoreUtil.copy(possibleResult);
            result.setRow(-1);
            result.setValid(false);
            return result;
        }
        return ErrorFactory.eINSTANCE.createInvalidSheetLocation(this.getFeatureName(structuralFeature));
    }

    private String getFeatureName(EStructuralFeature structuralFeature) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle == null) {
            return structuralFeature.getName();
        }
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            return structuralFeature.getName();
        }
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsLabelProviderImpl.class);
        if (serviceReference == null) {
            return structuralFeature.getName();
        }
        EMFFormsLabelProviderImpl labelProvider = (EMFFormsLabelProviderImpl)bundleContext.getService(serviceReference);
        if (labelProvider == null) {
            return structuralFeature.getName();
        }
        return labelProvider.getDisplayName(structuralFeature);
    }
}

