/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(name="EMFFormsSpreadsheetSingleAttributeConverter")
public class EMFFormsSpreadsheetSingleAttributeConverter
implements EMFFormsSpreadsheetValueConverter {
    private EMFFormsDatabindingEMF databinding;
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setDatabinding(EMFFormsDatabindingEMF databinding) {
        this.databinding = databinding;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public double isApplicable(EObject domainObject, VDomainModelReference dmr) {
        EStructuralFeature feature = EMFFormsSpreadsheetValueConverterHelper.getFeature(domainObject, dmr, (EMFFormsDatabinding)this.databinding, this.reportService);
        if (feature == null) {
            return Double.NaN;
        }
        if (!EAttribute.class.isInstance(feature)) {
            return Double.NaN;
        }
        if (feature.isMany()) {
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public void setCellValue(Cell cell, Object value, EStructuralFeature eStructuralFeature, ViewModelContext viewModelContext) throws EMFFormsConverterException {
        if (value == null) {
            return;
        }
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        if (eAttribute == null) {
            throw new EMFFormsConverterException("The provided eAttribute is null.");
        }
        EDataType attributeType = eAttribute.getEAttributeType();
        if (attributeType == null) {
            throw new EMFFormsConverterException("The attributeType of the provided eAttribute is null.");
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isBoolean(attributeType.getInstanceClass())) {
            cell.setCellValue(((Boolean)Boolean.class.cast(value)).booleanValue());
        } else if (EMFFormsSpreadsheetSingleAttributeConverter.isByte(attributeType.getInstanceClass()) || EMFFormsSpreadsheetSingleAttributeConverter.isShort(attributeType.getInstanceClass()) || EMFFormsSpreadsheetSingleAttributeConverter.isInteger(attributeType.getInstanceClass()) || EMFFormsSpreadsheetSingleAttributeConverter.isLong(attributeType.getInstanceClass()) || EMFFormsSpreadsheetSingleAttributeConverter.isFloat(attributeType.getInstanceClass()) || EMFFormsSpreadsheetSingleAttributeConverter.isDouble(attributeType.getInstanceClass())) {
            cell.setCellValue(((Number)Number.class.cast(value)).doubleValue());
        } else if (EMFFormsSpreadsheetSingleAttributeConverter.isBigInteger(attributeType.getInstanceClass())) {
            this.writeBigInteger(cell, value, viewModelContext);
        } else if (EMFFormsSpreadsheetSingleAttributeConverter.isBigDecimal(attributeType.getInstanceClass())) {
            this.writeBigDecimal(cell, value, viewModelContext);
        } else if (EMFFormsSpreadsheetSingleAttributeConverter.isDate(attributeType.getInstanceClass())) {
            cell.setCellValue(DateUtil.getExcelDate((Date)((Date)Date.class.cast(value))));
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Date"));
        } else if (EMFFormsSpreadsheetSingleAttributeConverter.isXMLDate(attributeType.getInstanceClass())) {
            XMLGregorianCalendar xmlDate = (XMLGregorianCalendar)XMLGregorianCalendar.class.cast(value);
            cell.setCellValue(DateUtil.getExcelDate((Calendar)xmlDate.toGregorianCalendar(TimeZone.getTimeZone("UTC"), null, xmlDate), (boolean)false));
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Date"));
        } else {
            cell.setCellValue(EcoreUtil.convertToString((EDataType)attributeType, (Object)value));
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Text"));
        }
    }

    private void writeBigDecimal(Cell cell, Object value, ViewModelContext viewModelContext) {
        BigDecimal bigDecimal = (BigDecimal)BigDecimal.class.cast(value);
        if (bigDecimal.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) > 0 || bigDecimal.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) < 0) {
            cell.setCellValue(bigDecimal.toString());
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Text"));
        } else {
            cell.setCellValue(bigDecimal.doubleValue());
        }
    }

    private void writeBigInteger(Cell cell, Object value, ViewModelContext viewModelContext) {
        BigInteger bigInteger = (BigInteger)BigInteger.class.cast(value);
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || bigInteger.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            cell.setCellValue(bigInteger.toString());
            cell.setCellStyle((CellStyle)viewModelContext.getContextValue("CellStyle_Text"));
        } else {
            cell.setCellValue(bigInteger.doubleValue());
        }
    }

    @Override
    public Object getCellValue(Cell cell, EStructuralFeature eStructuralFeature) throws EMFFormsConverterException {
        EAttribute eAttribute = (EAttribute)EAttribute.class.cast(eStructuralFeature);
        if (cell.getCellType() == 3) {
            return null;
        }
        if (eAttribute == null) {
            return null;
        }
        EDataType attributeType = eAttribute.getEAttributeType();
        if (attributeType == null) {
            return null;
        }
        try {
            return this.readCellValue(cell, attributeType);
        }
        catch (IllegalStateException e) {
            throw new EMFFormsConverterException(e);
        }
        catch (NumberFormatException e) {
            throw new EMFFormsConverterException(e);
        }
    }

    private Object readCellValue(Cell cell, EDataType attributeType) {
        if (EMFFormsSpreadsheetSingleAttributeConverter.isByte(attributeType.getInstanceClass())) {
            return Double.valueOf(cell.getNumericCellValue()).byteValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isShort(attributeType.getInstanceClass())) {
            return Double.valueOf(cell.getNumericCellValue()).shortValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isInteger(attributeType.getInstanceClass())) {
            return Double.valueOf(cell.getNumericCellValue()).intValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isLong(attributeType.getInstanceClass())) {
            return Double.valueOf(cell.getNumericCellValue()).longValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isFloat(attributeType.getInstanceClass())) {
            return Float.valueOf(Double.valueOf(cell.getNumericCellValue()).floatValue());
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isDouble(attributeType.getInstanceClass())) {
            return cell.getNumericCellValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isBigInteger(attributeType.getInstanceClass())) {
            if (cell.getCellType() == 0) {
                return BigInteger.valueOf((long)cell.getNumericCellValue());
            }
            return new BigInteger(cell.getStringCellValue());
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isBigDecimal(attributeType.getInstanceClass())) {
            if (cell.getCellType() == 0) {
                return BigDecimal.valueOf(cell.getNumericCellValue());
            }
            String value = cell.getStringCellValue();
            return new BigDecimal(value);
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isBoolean(attributeType.getInstanceClass())) {
            return cell.getBooleanCellValue();
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isDate(attributeType.getInstanceClass())) {
            return DateUtil.getJavaDate((double)cell.getNumericCellValue());
        }
        if (EMFFormsSpreadsheetSingleAttributeConverter.isXMLDate(attributeType.getInstanceClass())) {
            Calendar targetCal = DateUtil.getJavaCalendarUTC((double)cell.getNumericCellValue(), (boolean)false);
            if (targetCal == null) {
                return null;
            }
            return new XMLCalendar(targetCal.getTime(), 2);
        }
        return EcoreUtil.createFromString((EDataType)attributeType, (String)cell.getStringCellValue());
    }

    private static boolean isXMLDate(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return XMLGregorianCalendar.class.isAssignableFrom(clazz);
    }

    private static boolean isDate(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Date.class.isAssignableFrom(clazz);
    }

    private static boolean isBigDecimal(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return BigDecimal.class.isAssignableFrom(clazz);
    }

    private static boolean isBigInteger(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return BigInteger.class.isAssignableFrom(clazz);
    }

    private static boolean isBoolean(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Boolean.TYPE == clazz || Boolean.class.isAssignableFrom(clazz);
    }

    private static boolean isDouble(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Double.TYPE == clazz || Double.class.isAssignableFrom(clazz);
    }

    private static boolean isFloat(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Float.TYPE == clazz || Float.class.isAssignableFrom(clazz);
    }

    private static boolean isLong(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Long.TYPE == clazz || Long.class.isAssignableFrom(clazz);
    }

    private static boolean isInteger(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Integer.TYPE == clazz || Integer.class.isAssignableFrom(clazz);
    }

    private static boolean isShort(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Short.TYPE == clazz || Short.class.isAssignableFrom(clazz);
    }

    private static boolean isByte(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Byte.TYPE == clazz || Byte.class.isAssignableFrom(clazz);
    }
}

