/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.transfer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emfforms.internal.spreadsheet.core.EMFFormsSpreadsheetViewModelContext;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsAbstractSpreadsheetRenderer;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsIdProvider;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRenderTarget;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetRendererFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.transfer.EMFFormsSpreadsheetExporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSpreadsheetExporterImpl
implements EMFFormsSpreadsheetExporter {
    private final ReportService reportService;
    private final EMFFormsIdProvider idProvider;
    private final ViewProvider viewProvider;

    public EMFFormsSpreadsheetExporterImpl() {
        this(new ViewProvider(){

            @Override
            public VView getViewModel(EObject viewEobject, VViewModelProperties properties) {
                return ViewProviderHelper.getView((EObject)viewEobject, (VViewModelProperties)properties);
            }
        });
    }

    public EMFFormsSpreadsheetExporterImpl(ViewProvider viewProvider) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference reportServiceReference = bundleContext.getServiceReference(ReportService.class);
        this.reportService = (ReportService)bundleContext.getService(reportServiceReference);
        ServiceReference idProviderServiceReference = bundleContext.getServiceReference(EMFFormsIdProvider.class);
        this.idProvider = (EMFFormsIdProvider)bundleContext.getService(idProviderServiceReference);
        this.viewProvider = viewProvider;
    }

    @Override
    public Workbook render(Collection<? extends EObject> domainObjects, EObject viewEobject, VViewModelProperties properties, Map<EObject, Map<String, String>> additionalInformation) {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSpreadsheetRendererFactory.class);
        EMFFormsSpreadsheetRendererFactory emfFormsSpreadsheetRendererFactory = (EMFFormsSpreadsheetRendererFactory)bundleContext.getService(serviceReference);
        HSSFWorkbook workbook = new HSSFWorkbook();
        VView viewModel = this.viewProvider.getViewModel(viewEobject, properties);
        if (viewModel == null) {
            this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport("No view model could be found for the given EObject/ViewModelProperties", 4));
            return workbook;
        }
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setLocked(true);
        CellStyle cellStyle2 = workbook.createCellStyle();
        cellStyle2.setLocked(true);
        cellStyle2.setWrapText(true);
        CellStyle cellStyle3 = workbook.createCellStyle();
        cellStyle3.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
        CellStyle cellStyle4 = workbook.createCellStyle();
        cellStyle4.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"m/d/yy"));
        if (domainObjects == null) {
            try {
                EMFFormsSpreadsheetViewModelContext viewModelContext = new EMFFormsSpreadsheetViewModelContext(viewModel, null);
                EMFFormsAbstractSpreadsheetRenderer<VElement> eMFFormsAbstractSpreadsheetRenderer = emfFormsSpreadsheetRendererFactory.getRendererInstance(viewModelContext.getViewModel(), viewModelContext);
                eMFFormsAbstractSpreadsheetRenderer.render((Workbook)workbook, viewModelContext.getViewModel(), viewModelContext, new EMFFormsSpreadsheetRenderTarget("root", 0, 0));
            }
            catch (EMFFormsNoRendererException ex) {
                this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(ex, 4));
            }
        } else {
            int i = 0;
            for (EObject eObject : domainObjects) {
                if (!viewModel.getRootEClass().isInstance((Object)eObject)) {
                    this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(String.format("The provided view %1$s doesn't fit for the passed EObject %2$s", viewModel, eObject), 4));
                    continue;
                }
                try {
                    EMFFormsSpreadsheetViewModelContext viewModelContext = new EMFFormsSpreadsheetViewModelContext(viewModel, eObject);
                    viewModelContext.putContextValue("CellStyle_Locked", cellStyle);
                    viewModelContext.putContextValue("CellStyle_LockedWrapped", cellStyle2);
                    viewModelContext.putContextValue("CellStyle_Text", cellStyle3);
                    viewModelContext.putContextValue("CellStyle_Date", cellStyle4);
                    EMFFormsAbstractSpreadsheetRenderer<VElement> renderer = emfFormsSpreadsheetRendererFactory.getRendererInstance(viewModelContext.getViewModel(), viewModelContext);
                    renderer.render((Workbook)workbook, viewModelContext.getViewModel(), viewModelContext, new EMFFormsSpreadsheetRenderTarget("root", i++, 0));
                }
                catch (EMFFormsNoRendererException ex) {
                    this.reportService.report((AbstractReport)new EMFFormsSpreadsheetReport(ex, 4));
                }
            }
            this.writeAdditionalInfo((Workbook)workbook, additionalInformation);
        }
        return workbook;
    }

    private void writeAdditionalInfo(Workbook workbook, Map<EObject, Map<String, String>> additionalInformation) {
        if (additionalInformation == null) {
            return;
        }
        String sheetName = WorkbookUtil.createSafeSheetName((String)"AdditionalInformation");
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = workbook.createSheet(sheetName);
        }
        Row titleRow = sheet.createRow(0);
        Cell idCell = titleRow.getCell(0, Row.CREATE_NULL_AS_BLANK);
        idCell.setCellValue("EOBJECT_ID");
        CellStyle readOnly = workbook.getCellStyleAt((short)(workbook.getNumCellStyles() - 2));
        idCell.setCellStyle(readOnly);
        LinkedHashMap<String, Integer> keyColumnMap = new LinkedHashMap<String, Integer>();
        int column = 1;
        int row = 1;
        for (EObject eObject : additionalInformation.keySet()) {
            Row valueRow = sheet.createRow(row++);
            valueRow.getCell(0, Row.CREATE_NULL_AS_BLANK).setCellValue(this.idProvider.getId(eObject));
            Map<String, String> keyValueMap = additionalInformation.get(eObject);
            for (String key : keyValueMap.keySet()) {
                if (!keyColumnMap.containsKey(key)) {
                    keyColumnMap.put(key, column);
                    ++column;
                }
                Cell keyCell = titleRow.getCell(((Integer)keyColumnMap.get(key)).intValue(), Row.CREATE_NULL_AS_BLANK);
                keyCell.setCellValue(key);
                keyCell.setCellStyle(readOnly);
                Cell valueCell = valueRow.getCell(((Integer)keyColumnMap.get(key)).intValue(), Row.CREATE_NULL_AS_BLANK);
                valueCell.setCellValue(keyValueMap.get(key));
                valueCell.setCellStyle(readOnly);
            }
        }
    }

    public static interface ViewProvider {
        public VView getViewModel(EObject var1, VViewModelProperties var2);
    }
}

