/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.core.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsConverterException;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverter;
import org.eclipse.emfforms.spi.spreadsheet.core.converter.EMFFormsSpreadsheetValueConverterRegistry;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SettingLocation;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.Severity;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SpreadsheetImportResult;
import org.eclipse.emfforms.spi.spreadsheet.core.transfer.EMFFormsSpreadsheetImporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSpreadsheetImporterImpl
implements EMFFormsSpreadsheetImporter {
    private static final String ADDITIONAL_INFORMATION = WorkbookUtil.createSafeSheetName((String)"AdditionalInformation");

    @Override
    public SpreadsheetImportResult importSpreadsheet(Workbook workbook, EClass eClass) {
        return this.readData(workbook, eClass);
    }

    private SpreadsheetImportResult readData(Workbook workbook, EClass eClass) {
        SpreadsheetImportResult result = ErrorFactory.eINSTANCE.createSpreadsheetImportResult();
        ResourceSetImpl rs = new ResourceSetImpl();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (CommandStack)new BasicCommandStack(), (ResourceSet)rs);
        rs.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        Resource resource = rs.createResource(URI.createURI((String)"VIRTUAL_URI"));
        ArrayList<EObject> importedEObjects = new ArrayList<EObject>();
        Map<String, Map<Integer, Integer>> mapIdToSheetIdWithRowId = this.parseIds(workbook, result);
        for (String eObjectId : mapIdToSheetIdWithRowId.keySet()) {
            Map<Integer, Integer> sheetIdToRowId = mapIdToSheetIdWithRowId.get(eObjectId);
            EObject eObject = EcoreUtil.create((EClass)eClass);
            resource.getContents().add((Object)eObject);
            for (Integer sheetId : sheetIdToRowId.keySet()) {
                Sheet sheet = workbook.getSheetAt(sheetId.intValue());
                Row labelRow = sheet.getRow(0);
                Row row = sheet.getRow(sheetIdToRowId.get(sheetId).intValue());
                this.extractRowInformation(labelRow, row, eObject, result, sheet.getSheetName());
            }
            importedEObjects.add(eObject);
        }
        result.getImportedEObjects().addAll(importedEObjects);
        return result;
    }

    private void extractRowInformation(Row dmrRow, Row eObjectRow, EObject eObject, SpreadsheetImportResult errorReports, String sheetname) {
        int columnId = 1;
        while (columnId < eObjectRow.getLastCellNum()) {
            block20: {
                Cell cell = dmrRow.getCell(columnId);
                if (cell == null) {
                    errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_LabelCellDeleted"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, "NO CELL"));
                } else {
                    Comment cellComment = cell.getCellComment();
                    if (cellComment == null) {
                        errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_CommentDeleted"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                    } else {
                        String serializedDMR = cellComment.getString().getString();
                        if (serializedDMR == null || serializedDMR.isEmpty()) {
                            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_CommentEmpty"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                        } else {
                            VDomainModelReference dmr;
                            try {
                                dmr = this.deserializeDMR(serializedDMR);
                            }
                            catch (IOException iOException) {
                                errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_DMRDeserializationFailed"), ErrorFactory.eINSTANCE.createEMFLocation(eObject), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                                break block20;
                            }
                            if (!this.resolveDMR(dmr, eObject)) {
                                errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_DMRResolvementFailed"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                            } else {
                                EMFFormsSpreadsheetValueConverter converter;
                                IObservableValue observableValue;
                                try {
                                    observableValue = this.getObservableValue(dmr, eObject);
                                }
                                catch (DatabindingFailedException ex) {
                                    errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)MessageFormat.format("ImportError_DatabindingFailed", ex.getMessage())), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                                    break block20;
                                }
                                try {
                                    converter = this.getValueConverter(dmr, eObject);
                                }
                                catch (EMFFormsConverterException eMFFormsConverterException) {
                                    errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_NoValueConverter"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, 0, cell.getStringCellValue()));
                                    break block20;
                                }
                                EStructuralFeature feature = (EStructuralFeature)EStructuralFeature.class.cast(observableValue.getValueType());
                                Cell rowCell = feature.isUnsettable() ? eObjectRow.getCell(columnId, Row.RETURN_NULL_AND_BLANK) : eObjectRow.getCell(columnId, Row.CREATE_NULL_AS_BLANK);
                                if (rowCell != null) {
                                    Object convertedValue;
                                    try {
                                        convertedValue = converter.getCellValue(rowCell, feature);
                                    }
                                    catch (EMFFormsConverterException ex) {
                                        errorReports.reportError(Severity.ERROR, MessageFormat.format(LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_ValueConversionFailed"), ex.getMessage()), ErrorFactory.eINSTANCE.createEMFLocation(eObject, this.createSettingLocation(observableValue, feature), ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), cell.getStringCellValue()));
                                        break block20;
                                    }
                                    if (convertedValue != null && !this.checkTypes(feature, convertedValue)) {
                                        errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_InvalidType"), ErrorFactory.eINSTANCE.createEMFLocation(eObject, this.createSettingLocation(observableValue, feature), ErrorFactory.eINSTANCE.createDMRLocation(dmr)), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), cell.getStringCellValue()));
                                    } else {
                                        observableValue.setValue(convertedValue);
                                        errorReports.getSettingToSheetMap().add((Object)ErrorFactory.eINSTANCE.createSettingToSheetMapping(this.createSettingLocation(observableValue, feature), ErrorFactory.eINSTANCE.createSheetLocation(sheetname, columnId, eObjectRow.getRowNum(), cell.getStringCellValue())));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++columnId;
        }
    }

    private boolean checkTypes(EStructuralFeature feature, Object convertedValue) {
        Class featureType = feature.getEType().getInstanceClass();
        if (convertedValue == null) {
            return !featureType.isPrimitive();
        }
        Class<?> valueType = convertedValue.getClass();
        if (feature.isMany() && Collection.class.isInstance(convertedValue)) {
            Collection collection = (Collection)Collection.class.cast(convertedValue);
            for (Object object : collection) {
                if (this.checkTypes(feature, object)) continue;
                return false;
            }
            return true;
        }
        if (featureType.isPrimitive() && !valueType.isPrimitive()) {
            Class<?> primitiveClass = this.getPrimitiveClass(valueType);
            if (primitiveClass == null) {
                return false;
            }
            return featureType.isAssignableFrom(primitiveClass);
        }
        if (!featureType.isPrimitive() && valueType.isPrimitive()) {
            Class<?> primitiveClass = this.getPrimitiveClass(featureType);
            if (primitiveClass == null) {
                return false;
            }
            return primitiveClass.isAssignableFrom(valueType);
        }
        return featureType.isAssignableFrom(valueType);
    }

    private Class<?> getPrimitiveClass(Class<?> clazz) {
        try {
            return (Class)clazz.getField("TYPE").get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {}
        return null;
    }

    private SettingLocation createSettingLocation(IObservableValue observableValue, EStructuralFeature feature) {
        EObject eObject = (EObject)EObject.class.cast(((IObserving)IObserving.class.cast(observableValue)).getObserved());
        return ErrorFactory.eINSTANCE.createSettingLocation(eObject, feature);
    }

    private boolean resolveDMR(VDomainModelReference dmr, EObject eObject) {
        return dmr.init(eObject);
    }

    private Map<String, Map<Integer, Integer>> parseIds(Workbook workbook, SpreadsheetImportResult errorReports) {
        LinkedHashMap<String, Map<Integer, Integer>> result = new LinkedHashMap<String, Map<Integer, Integer>>();
        int sheetId = 0;
        while (sheetId < workbook.getNumberOfSheets()) {
            Sheet sheet = workbook.getSheetAt(sheetId);
            if (!ADDITIONAL_INFORMATION.equals(sheet.getSheetName())) {
                Row labelRow = sheet.getRow(0);
                if (!"EOBJECT_ID".equals(labelRow.getCell(0).getStringCellValue())) {
                    errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)String.format("ImportError_FirstColumnWrong", "EOBJECT_ID", labelRow.getCell(0).getStringCellValue())), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, 0, "NO CELL"));
                } else {
                    int rowId = 3;
                    while (rowId <= sheet.getLastRowNum()) {
                        Row row = sheet.getRow(rowId);
                        String eObjectId = row.getCell(0, Row.CREATE_NULL_AS_BLANK).getStringCellValue();
                        if (eObjectId == null || eObjectId.isEmpty()) {
                            errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_NoEObjectID"), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, rowId, "EOBJECT_ID"));
                        } else {
                            if (!result.containsKey(eObjectId)) {
                                result.put(eObjectId, new LinkedHashMap());
                            }
                            if (((Map)result.get(eObjectId)).containsKey(sheetId)) {
                                errorReports.reportError(Severity.ERROR, LocalizationServiceHelper.getString(this.getClass(), (String)"ImportError_DuplicateEObjectID"), ErrorFactory.eINSTANCE.createSheetLocation(workbook.getSheetName(sheetId), 0, rowId, "EOBJECT_ID"));
                            } else {
                                ((Map)result.get(eObjectId)).put(sheetId, rowId);
                            }
                        }
                        ++rowId;
                    }
                }
            }
            ++sheetId;
        }
        return result;
    }

    private IObservableValue getObservableValue(VDomainModelReference dmr, EObject eObject) throws DatabindingFailedException {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        EMFFormsDatabinding emfFormsDatabinding = (EMFFormsDatabinding)bundleContext.getService(serviceReference);
        return emfFormsDatabinding.getObservableValue(dmr, eObject);
    }

    private EMFFormsSpreadsheetValueConverter getValueConverter(VDomainModelReference dmr, EObject eObject) throws EMFFormsConverterException {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSpreadsheetValueConverterRegistry.class);
        EMFFormsSpreadsheetValueConverterRegistry emfFormsDatabinding = (EMFFormsSpreadsheetValueConverterRegistry)bundleContext.getService(serviceReference);
        return emfFormsDatabinding.getConverter(eObject, dmr);
    }

    private VDomainModelReference deserializeDMR(String serializedDMR) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createURI((String)"VIRTAUAL_URI"));
        URIConverter.ReadableInputStream is = new URIConverter.ReadableInputStream(serializedDMR, "UTF-8");
        resource.load((InputStream)is, null);
        return (VDomainModelReference)resource.getContents().get(0);
    }
}

