/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.edapt;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecp.view.edapt.PackageDependencyGraph;

public class PackageDependencyIterator
implements Iterator<Set<String>> {
    private final Set<PackageDependencyGraph.PackageTreeNode> nextCandidates;
    private final Set<PackageDependencyGraph.PackageTreeNode> visitedNodes = new LinkedHashSet<PackageDependencyGraph.PackageTreeNode>();
    private final Set<PackageDependencyGraph.PackageTreeNode> unvisitedNodes;
    private Set<PackageDependencyGraph.PackageTreeNode> next;

    public PackageDependencyIterator(Collection<PackageDependencyGraph.PackageTreeNode> roots, Collection<PackageDependencyGraph.PackageTreeNode> allNodes) {
        this.unvisitedNodes = new LinkedHashSet<PackageDependencyGraph.PackageTreeNode>(allNodes);
        this.nextCandidates = new LinkedHashSet<PackageDependencyGraph.PackageTreeNode>(roots);
        this.next = this.findNext();
    }

    @Override
    public boolean hasNext() {
        return !this.next.isEmpty();
    }

    @Override
    public Set<String> next() {
        this.visitedNodes.addAll(this.next);
        this.unvisitedNodes.removeAll(this.next);
        LinkedHashSet<String> nsuri = new LinkedHashSet<String>();
        for (PackageDependencyGraph.PackageTreeNode nextNode : this.next) {
            nsuri.add(nextNode.getNSURI());
        }
        this.next = this.findNext();
        return nsuri;
    }

    private Set<PackageDependencyGraph.PackageTreeNode> findNext() {
        LinkedHashSet<PackageDependencyGraph.PackageTreeNode> result = new LinkedHashSet<PackageDependencyGraph.PackageTreeNode>();
        for (PackageDependencyGraph.PackageTreeNode node : this.nextCandidates) {
            boolean hasUnvisitedParent = false;
            for (PackageDependencyGraph.PackageTreeNode parent : node.getParents()) {
                if (this.visitedNodes.contains(parent)) continue;
                hasUnvisitedParent = true;
                break;
            }
            if (hasUnvisitedParent) continue;
            for (PackageDependencyGraph.PackageTreeNode child : node.getChildren()) {
                if (this.visitedNodes.contains(child)) continue;
                this.nextCandidates.add(child);
            }
            result.add(node);
            break;
        }
        if (result.isEmpty() && !this.unvisitedNodes.isEmpty()) {
            result.addAll(this.getCircleSet());
        }
        for (PackageDependencyGraph.PackageTreeNode packageTreeNode : result) {
            this.nextCandidates.remove(packageTreeNode);
        }
        return result;
    }

    private Collection<? extends PackageDependencyGraph.PackageTreeNode> getCircleSet() {
        LinkedHashMap<PackageDependencyGraph.PackageTreeNode, Set<PackageDependencyGraph.PackageTreeNode>> nodeToCircleMap = new LinkedHashMap<PackageDependencyGraph.PackageTreeNode, Set<PackageDependencyGraph.PackageTreeNode>>();
        LinkedHashSet<Set<PackageDependencyGraph.PackageTreeNode>> allCircles = new LinkedHashSet<Set<PackageDependencyGraph.PackageTreeNode>>();
        for (PackageDependencyGraph.PackageTreeNode nodeToAllocate : this.unvisitedNodes) {
            Set<PackageDependencyGraph.PackageTreeNode> circle;
            Set set = circle = nodeToCircleMap.containsKey(nodeToAllocate) ? (Set)nodeToCircleMap.get(nodeToAllocate) : new LinkedHashSet();
            if (!nodeToCircleMap.containsKey(nodeToAllocate)) {
                circle.add(nodeToAllocate);
                nodeToCircleMap.put(nodeToAllocate, circle);
                allCircles.add(circle);
            }
            Set<PackageDependencyGraph.PackageTreeNode> outgoingEdges = nodeToAllocate.getChildren();
            for (PackageDependencyGraph.PackageTreeNode outgoingEdge : outgoingEdges) {
                boolean hasPathToOtherNode = this.hasPathToOtherNode(outgoingEdge, nodeToAllocate, new LinkedHashSet<PackageDependencyGraph.PackageTreeNode>());
                if (!hasPathToOtherNode) continue;
                circle.add(outgoingEdge);
                nodeToCircleMap.put(outgoingEdge, circle);
            }
        }
        return this.findRootCircle(allCircles);
    }

    private Collection<? extends PackageDependencyGraph.PackageTreeNode> findRootCircle(Set<Set<PackageDependencyGraph.PackageTreeNode>> allCircles) {
        for (Set<PackageDependencyGraph.PackageTreeNode> circle : allCircles) {
            boolean isRoot = true;
            for (PackageDependencyGraph.PackageTreeNode node : circle) {
                for (PackageDependencyGraph.PackageTreeNode mustBeInCircle : node.getParents()) {
                    if (this.visitedNodes.contains(mustBeInCircle) || circle.contains(mustBeInCircle)) continue;
                    isRoot = false;
                    break;
                }
                if (!isRoot) break;
            }
            if (!isRoot) continue;
            return circle;
        }
        throw new IllegalStateException("No root circle found");
    }

    private boolean hasPathToOtherNode(PackageDependencyGraph.PackageTreeNode start, PackageDependencyGraph.PackageTreeNode target, Set<PackageDependencyGraph.PackageTreeNode> visitedNodes) {
        visitedNodes.add(start);
        Set<PackageDependencyGraph.PackageTreeNode> outgoingNodes = start.getChildren();
        if (outgoingNodes.contains(target)) {
            return true;
        }
        boolean result = false;
        for (PackageDependencyGraph.PackageTreeNode outgoingNode : outgoingNodes) {
            if (visitedNodes.contains(outgoingNode)) continue;
            result |= this.hasPathToOtherNode(outgoingNode, target, visitedNodes);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

