/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.view.internal.service;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.ide.view.service.IDEViewModelRegistry;
import org.eclipse.emf.ecp.ide.view.service.ViewModelEditorCallback;
import org.eclipse.emf.ecp.view.spi.model.VView;

public class IDEViewModelRegistryImpl
implements IDEViewModelRegistry {
    private final Map<VView, ViewModelEditorCallback> viewModelViewModelEditorMapping = new LinkedHashMap<VView, ViewModelEditorCallback>();
    private final Map<String, Set<VView>> ecoreViewMapping = new LinkedHashMap<String, Set<VView>>();
    private final Map<VView, String> viewModelviewModelFileMapping = new LinkedHashMap<VView, String>();
    private final Map<String, IResourceChangeListener> resourceChangeListeners = new LinkedHashMap<String, IResourceChangeListener>();
    private final Map<String, Set<String>> viewToRelatedEcorePaths = new LinkedHashMap<String, Set<String>>();

    @Override
    public void register(String ecorePath, VView viewModel) {
        LinkedHashSet otherRelatedWorkspaceURIs = new LinkedHashSet();
        for (String viewModelEcorePath : viewModel.getEcorePaths()) {
            otherRelatedWorkspaceURIs.addAll(EcoreHelper.getOtherRelatedWorkspacePaths((String)viewModelEcorePath));
        }
        LinkedHashSet<String> otherRelatedWorkspacePaths = new LinkedHashSet<String>();
        for (String uri : otherRelatedWorkspaceURIs) {
            URI platformURI = URI.createURI((String)uri);
            StringBuilder builder = new StringBuilder();
            int i = 1;
            while (i < platformURI.segmentCount()) {
                builder.append("/");
                builder.append(URI.createURI((String)uri).segment(i));
                ++i;
            }
            otherRelatedWorkspacePaths.add(builder.toString());
        }
        this.viewToRelatedEcorePaths.put(ecorePath, otherRelatedWorkspacePaths);
        if (!this.ecoreViewMapping.containsKey(ecorePath) || this.ecoreViewMapping.get(ecorePath).isEmpty()) {
            if (this.ecoreViewMapping.get(ecorePath) == null) {
                this.ecoreViewMapping.put(ecorePath, new LinkedHashSet());
            }
            if (!this.resourceChangeListeners.containsKey(ecorePath)) {
                this.addECoreChangeListener(ecorePath);
            }
        }
        this.ecoreViewMapping.get(ecorePath).add(viewModel);
    }

    private void addECoreChangeListener(final String ecorePath) {
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    while (delta.getAffectedChildren().length != 0) {
                        delta = delta.getAffectedChildren()[0];
                    }
                    for (VView view : (Set)IDEViewModelRegistryImpl.this.ecoreViewMapping.get(ecorePath)) {
                        LinkedHashSet ecorePathsToCheck = new LinkedHashSet();
                        if (view.getEcorePaths() != null) {
                            ecorePathsToCheck.addAll(view.getEcorePaths());
                        }
                        if (IDEViewModelRegistryImpl.this.viewToRelatedEcorePaths.containsKey(ecorePath)) {
                            ecorePathsToCheck.addAll((Collection)IDEViewModelRegistryImpl.this.viewToRelatedEcorePaths.get(ecorePath));
                        }
                        for (String path : ecorePathsToCheck) {
                            ViewModelEditorCallback viewModelEditorCallback;
                            if (!delta.getResource().getFullPath().toString().contains(path) || (viewModelEditorCallback = (ViewModelEditorCallback)IDEViewModelRegistryImpl.this.viewModelViewModelEditorMapping.get(view)) == null) continue;
                            viewModelEditorCallback.signalEcoreOutOfSync();
                        }
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
        this.resourceChangeListeners.put(ecorePath, listener);
    }

    @Override
    public void unregister(String registeredEcorePath, VView viewModel) {
        if (this.ecoreViewMapping.containsKey(registeredEcorePath)) {
            this.ecoreViewMapping.get(registeredEcorePath).remove(viewModel);
            if (this.ecoreViewMapping.get(registeredEcorePath).size() == 0) {
                IResourceChangeListener listener = this.resourceChangeListeners.get(registeredEcorePath);
                if (listener != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
                    this.resourceChangeListeners.remove(registeredEcorePath);
                }
                this.viewToRelatedEcorePaths.remove(registeredEcorePath);
            }
        }
    }

    @Override
    public void registerViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) throws IOException {
        this.viewModelViewModelEditorMapping.put(viewModel, viewModelEditor);
    }

    @Override
    public void unregisterViewModelEditor(VView viewModel, ViewModelEditorCallback viewModelEditor) {
        this.viewModelViewModelEditorMapping.remove(viewModel);
        EList ecorePaths = viewModel.getEcorePaths();
        for (String ecorePath : ecorePaths) {
            EcoreHelper.unregisterEcore((String)ecorePath);
        }
    }

    @Override
    public void registerViewModel(VView view, String path) {
        if (!this.viewModelviewModelFileMapping.containsKey(view)) {
            this.viewModelviewModelFileMapping.put(view, path);
        }
    }
}

