/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.ui.testresult;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.eunit.ui.testresult.ResultSummaryBlock;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class RSTreeLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private List<Color> colors;
    private Color red = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
    private Color green = new Color((Device)Display.getCurrent(), new RGB(0, 128, 0));
    private Color purple = new Color((Device)Display.getCurrent(), new RGB(184, 0, 73));
    private Color orange = new Color((Device)Display.getCurrent(), new RGB(255, 127, 0));
    private Font boldFont;

    public RSTreeLabelProvider() {
        this.colors = new ArrayList<Color>();
        this.colors.add(this.red);
        this.colors.add(this.green);
        this.colors.add(this.purple);
        this.colors.add(this.orange);
        this.boldFont = new FontRegistry().getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
    }

    public String getText(Object element) {
        if (element instanceof ResultSummaryBlock.Record_ResultSummary) {
            ResultSummaryBlock.Record_ResultSummary rs = (ResultSummaryBlock.Record_ResultSummary)element;
            return rs.name;
        }
        if (element instanceof ResultSummaryBlock.TestResultRootNode) {
            return ((ResultSummaryBlock.TestResultRootNode)element).rootname;
        }
        if (element instanceof ResultSummaryBlock.TestResultPkgNode) {
            return ((ResultSummaryBlock.TestResultPkgNode)element).pkgName;
        }
        return element.toString();
    }

    public Color getBackground(Object arg0) {
        return null;
    }

    public Color getForeground(Object element) {
        int resultCode = -1;
        if (element instanceof ResultSummaryBlock.Record_ResultSummary) {
            resultCode = ((ResultSummaryBlock.Record_ResultSummary)element).resultCode;
        } else if (element instanceof ResultSummaryBlock.TestResultPkgNode) {
            resultCode = ((ResultSummaryBlock.TestResultPkgNode)element).statisticCnts.overallResult();
        } else if (element instanceof ResultSummaryBlock.TestResultRootNode) {
            resultCode = ((ResultSummaryBlock.TestResultRootNode)element).statisticCnts.overallResult();
        }
        switch (resultCode) {
            case 0: {
                return this.green;
            }
            case 1: {
                return this.red;
            }
            case 2: {
                return this.purple;
            }
            case 3: {
                return this.orange;
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        int resultCode = -1;
        if (element instanceof ResultSummaryBlock.Record_ResultSummary) {
            resultCode = ((ResultSummaryBlock.Record_ResultSummary)element).resultCode;
        } else if (element instanceof ResultSummaryBlock.TestResultPkgNode) {
            resultCode = ((ResultSummaryBlock.TestResultPkgNode)element).statisticCnts.overallResult();
        } else if (element instanceof ResultSummaryBlock.TestResultRootNode) {
            resultCode = ((ResultSummaryBlock.TestResultRootNode)element).statisticCnts.overallResult();
        }
        if (resultCode == 1 || resultCode == 2) {
            return this.boldFont;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.colors != null && !this.colors.isEmpty()) {
            for (Color color : this.colors) {
                color.dispose();
            }
        }
        this.colors.clear();
        this.colors = null;
    }
}

