/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.ITextViewer;

public class EGLDeclarationProposalHandler
extends EGLAbstractProposalHandler {
    private Node functionContainerPart;
    private Node functionPart;
    private boolean parens;

    public EGLDeclarationProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof NestedFunction) {
                this.functionPart = boundNode;
                this.functionContainerPart = boundNode.getParent();
            } else if (boundNode instanceof Part) {
                this.functionContainerPart = boundNode;
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals(boolean parens, boolean constants) {
        return this.getProposals(null, parens, constants);
    }

    public List getProposals(Node boundNode) {
        return this.getProposals(boundNode, false, true);
    }

    public List getProposals(Node node, boolean parens, boolean constants) {
        this.parens = parens;
        ArrayList proposals = new ArrayList();
        proposals.addAll(this.getParameterProposals(false));
        proposals.addAll(this.getContainerVariableProposals(constants, false));
        proposals.addAll(this.getVariableProposals(constants, false));
        if (node != null) {
            proposals.addAll(this.getExceptionDeclarationProposals(node));
        }
        return proposals;
    }

    private List getParameterProposals(boolean quoted) {
        return this.getParameterProposals(new DefaultDataBindingFilter(), quoted);
    }

    private List getParameterProposals(IDataBindingFilter dataBindingFilter, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            FunctionMember function = (FunctionMember)((NestedFunction)this.functionPart).getName().resolveMember();
            for (FunctionParameter parm : function.getParameters()) {
                if (!parm.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)parm) || !this.precondition((Member)parm)) continue;
                String proposalString = this.getProposalString(parm.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal((Member)parm, proposalString, 75, quoted, true));
            }
        }
        return proposals;
    }

    private String getProposalString(String string) {
        if (this.parens) {
            return "(" + string + ")";
        }
        return string;
    }

    private List getContainerVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getContainerVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private boolean inStaticFunction() {
        if (this.functionPart != null) {
            return ((NestedFunction)this.functionPart).isStatic();
        }
        return false;
    }

    private List getContainerVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionContainerPart != null) {
            org.eclipse.edt.mof.egl.Part part = (org.eclipse.edt.mof.egl.Part)((Part)this.functionContainerPart).getName().resolveType();
            List fields = BindingUtil.getAllFields((Type)part);
            ArrayList<String> names = new ArrayList<String>();
            for (Field field : fields) {
                String name = NameUtile.getAsName((String)field.getCaseSensitiveName());
                if (names.contains(name)) continue;
                names.add(name);
                if (field.getAccessKind() == AccessKind.ACC_PRIVATE && field.getContainer() != part || !field.isStatic().booleanValue() && this.inStaticFunction() || !field.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)field) || !this.precondition((Member)field) || !includeConstants && field instanceof ConstantField) continue;
                String proposalString = this.getProposalString(field.getCaseSensitiveName());
                proposals.add(this.createDeclarationProposal((Member)field, proposalString, 75, quoted, false));
            }
        }
        return proposals;
    }

    private List getVariableProposals(boolean includeConstants, boolean quoted) {
        return this.getVariableProposals(new DefaultDataBindingFilter(), includeConstants, quoted);
    }

    private List getVariableProposals(IDataBindingFilter dataBindingFilter, boolean includeConstants, boolean quoted) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.functionPart != null) {
            Stack blocks = new Stack();
            blocks.push(new ArrayList());
            List statements = ((NestedFunction)this.functionPart).getStmts();
            this.addDeclarations(statements, blocks);
            Iterator iter = blocks.iterator();
            while (iter.hasNext()) {
                for (Field field : (List)iter.next()) {
                    if (!field.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) || !dataBindingFilter.dataBindingPasses((Member)field) || !this.precondition((Member)field) || !includeConstants && field instanceof ConstantField) continue;
                    String proposalString = this.getProposalString(field.getCaseSensitiveName());
                    proposals.add(this.createDeclarationProposal((Member)field, proposalString, 75, quoted, true));
                }
            }
        }
        return proposals;
    }

    private List getExceptionDeclarationProposals(Node node) {
        return this.getExceptionDeclarationProposals(node, new DefaultDataBindingFilter());
    }

    private List getExceptionDeclarationProposals(Node node, IDataBindingFilter dataBindingFilter) {
        Field field;
        Name exceptionName;
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        OnExceptionBlock onExceptionBlock = this.getOnExceptionBlock(node);
        if (onExceptionBlock != null && (exceptionName = onExceptionBlock.getExceptionName()) != null && exceptionName.getCanonicalName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && (field = (Field)exceptionName.resolveMember()).getName().toUpperCase().startsWith(this.getPrefix().toUpperCase()) && dataBindingFilter.dataBindingPasses((Member)field) && this.precondition((Member)field)) {
            String proposalString = this.getProposalString(field.getCaseSensitiveName());
            proposals.add(this.createDeclarationProposal((Member)field, proposalString, 75, false, true));
        }
        return proposals;
    }

    private OnExceptionBlock getOnExceptionBlock(Node node) {
        final OnExceptionBlock[] onExceptionBlock = new OnExceptionBlock[1];
        while (node != null) {
            node.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(OnExceptionBlock onExceptionBlk) {
                    onExceptionBlock[0] = onExceptionBlk;
                    return false;
                }
            });
            node = node.getParent();
        }
        return onExceptionBlock[0];
    }

    private boolean addDeclarations(List<Statement> statements, final Stack blocks) {
        boolean done = false;
        Statement lastStatement = null;
        Iterator<Statement> iter = statements.iterator();
        while (iter.hasNext() && !done) {
            Statement nextStmt;
            lastStatement = nextStmt = iter.next();
            if (nextStmt.getOffset() > this.getDocumentOffset()) {
                done = true;
                continue;
            }
            if (nextStmt.canIncludeOtherStatements()) {
                Iterator blockIter = nextStmt.getStatementBlocks().iterator();
                while (blockIter.hasNext()) {
                    blocks.push(new ArrayList());
                    nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(ForStatement forStatement) {
                            Field field;
                            if (forStatement.hasVariableDeclaration() && (field = (Field)forStatement.getVariableDeclarationName().resolveMember()) != null) {
                                ((List)blocks.peek()).add(field);
                            }
                            return false;
                        }
                    });
                    if (this.addDeclarations((List)blockIter.next(), blocks)) {
                        done = true;
                        continue;
                    }
                    blocks.pop();
                }
                continue;
            }
            nextStmt.accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                    Iterator iter = functionDataDeclaration.getNames().iterator();
                    while (iter.hasNext()) {
                        Field field = (Field)((Name)iter.next()).resolveMember();
                        if (field == null) continue;
                        ((List)blocks.peek()).add(field);
                    }
                    return false;
                }
            });
        }
        if (!done && lastStatement != null && lastStatement.getOffset() + lastStatement.getLength() > this.getDocumentOffset()) {
            done = true;
        }
        return done;
    }

    private String getAdditionalInfo1(Member field) {
        if (field.getType() != null) {
            String type = EGLDeclarationProposalHandler.getTypeString(field.getType());
            if (field instanceof ProgramParameter) {
                return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
            }
            if (field instanceof FunctionParameter) {
                return MessageFormat.format(UINlsStrings.CAProposal_ParameterDeclaration, type);
            }
            if (field.getContainer() instanceof FunctionMember) {
                if (field instanceof ConstantField) {
                    return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclaration, type);
                }
                return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, type);
            }
            if (field instanceof ConstantField) {
                return MessageFormat.format(UINlsStrings.CAProposal_ConstantDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
            }
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, type, EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
        }
        if (this.functionContainerPart == null) {
            return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclaration, "");
        }
        return MessageFormat.format(UINlsStrings.CAProposal_VariableDeclarationIn, "", EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer()));
    }

    private EGLCompletionProposal createDeclarationProposal(Member field, String proposalString, int relevance, boolean quoted, boolean isLocalVariable) {
        String imgStr;
        if (quoted) {
            proposalString = "\"" + proposalString + "\"";
        }
        String string = imgStr = this.isPrivateMember(field) ? (imgStr = "org.eclipse.edt.ide.ui.private_co.gif") : "org.eclipse.edt.ide.ui.envvar_obj.gif";
        if (isLocalVariable) {
            imgStr = "org.eclipse.edt.ide.ui.localvariable_obj.gif";
        } else if (field.getContainer() instanceof Record) {
            imgStr = "org.eclipse.edt.ide.ui.stritm_obj.gif";
        }
        String displayStr = isLocalVariable ? String.valueOf(field.getCaseSensitiveName()) + " : " + EGLDeclarationProposalHandler.getTypeString(field.getType()) : String.valueOf(field.getCaseSensitiveName()) + " : " + EGLDeclarationProposalHandler.getTypeString(field.getType()) + " - " + EGLDeclarationProposalHandler.getNameFromElement((Element)field.getContainer());
        return new EGLCompletionProposal(this.viewer, displayStr, proposalString, this.getAdditionalInfo1(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), relevance, imgStr);
    }

    protected boolean precondition(Member member) {
        return true;
    }

    private static class DefaultDataBindingFilter
    implements IDataBindingFilter {
        private DefaultDataBindingFilter() {
        }

        @Override
        public boolean dataBindingPasses(Member member) {
            return true;
        }
    }

    private static interface IDataBindingFilter {
        public boolean dataBindingPasses(Member var1);
    }
}

